/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.common;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.junit.rules.ExternalResource;

public abstract class UndertowServer
extends ExternalResource {
    protected final Supplier<SSLContext> serverSslContext;
    protected final int port;
    protected final String contextRoot;
    protected final String path;

    protected UndertowServer(Supplier<SSLContext> serverSslContext, int port, String contextRoot) {
        this(serverSslContext, port, contextRoot, "");
    }

    protected UndertowServer(Supplier<SSLContext> serverSslContext, int port, String contextRoot, String path) {
        this.serverSslContext = serverSslContext;
        this.port = port;
        this.contextRoot = contextRoot != null ? contextRoot : "";
        this.path = path != null ? path : "";
    }

    public URI createUri() throws URISyntaxException {
        return this.createUri(null);
    }

    public URI createUri(String alternatePath) throws URISyntaxException {
        String path = alternatePath != null ? this.contextRoot + alternatePath : this.contextRoot + this.path;
        System.out.println("My PATH " + path);
        return new URI(this.serverSslContext != null ? "https" : "http", null, "localhost", this.port, path, null, null);
    }

    public void forceShutdown() {
        this.after();
    }

    public String getContextRoot() {
        return this.contextRoot;
    }
}

