/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.asn1;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.NoSuchElementException;
import org.wildfly.security.asn1.ASN1;
import org.wildfly.security.asn1.ASN1Decoder;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.util.ByteIterator;

public class DERDecoder
implements ASN1Decoder {
    private ByteIterator bi;
    private ArrayDeque<DecoderState> states = new ArrayDeque();
    private int implicitTag = -1;

    public DERDecoder(byte[] buf) {
        this.bi = ByteIterator.ofBytes(buf);
    }

    public DERDecoder(byte[] buf, int offset, int length) {
        this.bi = ByteIterator.ofBytes(buf, offset, length);
    }

    public DERDecoder(ByteIterator bi) {
        this.bi = bi;
    }

    @Override
    public void startSequence() throws ASN1Exception {
        this.readTag(48);
        int length = this.readLength();
        this.states.add(new DecoderState(48, this.bi.offset() + length));
    }

    @Override
    public void endSequence() throws ASN1Exception {
        DecoderState lastState = this.states.peekLast();
        if (lastState == null || lastState.getTag() != 48) {
            throw new IllegalStateException("No sequence to end");
        }
        this.endConstructedElement(lastState.getNextElementIndex());
        this.states.removeLast();
    }

    @Override
    public void startSet() throws ASN1Exception {
        this.readTag(49);
        int length = this.readLength();
        this.states.add(new DecoderState(49, this.bi.offset() + length));
    }

    @Override
    public void endSet() throws ASN1Exception {
        DecoderState lastState = this.states.peekLast();
        if (lastState == null || lastState.getTag() != 49) {
            throw new IllegalStateException("No set to end");
        }
        this.endConstructedElement(lastState.getNextElementIndex());
        this.states.removeLast();
    }

    @Override
    public void startSetOf() throws ASN1Exception {
        this.startSet();
    }

    @Override
    public void endSetOf() throws ASN1Exception {
        this.endSet();
    }

    @Override
    public void startExplicit(int number) throws ASN1Exception {
        this.startExplicit(128, number);
    }

    @Override
    public void startExplicit(int clazz, int number) throws ASN1Exception {
        int explicitTag = clazz | 0x20 | number;
        this.readTag(explicitTag);
        int length = this.readLength();
        this.states.add(new DecoderState(explicitTag, this.bi.offset() + length));
    }

    @Override
    public void endExplicit() throws ASN1Exception {
        DecoderState lastState = this.states.peekLast();
        if (lastState == null || lastState.getTag() == 48 || lastState.getTag() == 49 || (lastState.getTag() & 0x20) == 0) {
            throw new IllegalStateException("No explicitly tagged element to end");
        }
        this.endConstructedElement(lastState.getNextElementIndex());
        this.states.removeLast();
    }

    private void endConstructedElement(int nextElementIndex) throws ASN1Exception {
        int pos = this.bi.offset();
        if (pos < nextElementIndex) {
            int i;
            for (i = 0; i < nextElementIndex - pos && this.bi.hasNext(); ++i) {
                this.bi.next();
            }
            if (i != nextElementIndex - pos) {
                throw new ASN1Exception("Unexpected end of input");
            }
        } else if (pos > nextElementIndex) {
            throw new IllegalStateException();
        }
    }

    @Override
    public byte[] decodeOctetString() throws ASN1Exception {
        this.readTag(4);
        int length = this.readLength();
        byte[] result = new byte[length];
        if (length != 0 && this.bi.drain(result, 0, length) != length) {
            throw new ASN1Exception("Unexpected end of input");
        }
        return result;
    }

    @Override
    public String decodeOctetStringAsString() throws ASN1Exception {
        return this.decodeOctetStringAsString(StandardCharsets.UTF_8.name());
    }

    @Override
    public String decodeOctetStringAsString(String charSet) throws ASN1Exception {
        this.readTag(4);
        int length = this.readLength();
        byte[] octets = new byte[length];
        if (length != 0 && this.bi.drain(octets, 0, length) != length) {
            throw new ASN1Exception("Unexpected end of input");
        }
        try {
            return new String(octets, charSet);
        }
        catch (UnsupportedEncodingException e) {
            throw new ASN1Exception(e.getMessage());
        }
    }

    @Override
    public String decodeIA5String() throws ASN1Exception {
        byte[] octets = this.decodeIA5StringAsBytes();
        return new String(octets, StandardCharsets.US_ASCII);
    }

    @Override
    public byte[] decodeIA5StringAsBytes() throws ASN1Exception {
        this.readTag(22);
        int length = this.readLength();
        byte[] result = new byte[length];
        if (length != 0 && this.bi.drain(result, 0, length) != length) {
            throw new ASN1Exception("Unexpected end of input");
        }
        return result;
    }

    @Override
    public byte[] decodeBitString() throws ASN1Exception {
        this.readTag(3);
        int length = this.readLength();
        byte[] result = new byte[length - 1];
        int numUnusedBits = this.bi.next();
        if (numUnusedBits < 0 || numUnusedBits > 7) {
            throw new ASN1Exception("Invalid number of unused bits");
        }
        if (numUnusedBits == 0) {
            for (int i = 0; i < length - 1; ++i) {
                result[i] = (byte)this.bi.next();
            }
        } else {
            int leftShift = 8 - numUnusedBits;
            int previous = 0;
            for (int i = 0; i < length - 1; ++i) {
                int next = this.bi.next();
                result[i] = i == 0 ? (byte)(next >>> numUnusedBits) : (byte)(next >>> numUnusedBits | previous << leftShift);
                previous = next;
            }
        }
        return result;
    }

    @Override
    public String decodeBitStringAsString() throws ASN1Exception {
        this.readTag(3);
        int length = this.readLength();
        int numUnusedBits = this.bi.next();
        if (numUnusedBits < 0 || numUnusedBits > 7) {
            throw new ASN1Exception("Invalid number of unused bits");
        }
        int k = 0;
        int numBits = (length - 1) * 8 - numUnusedBits;
        StringBuilder result = new StringBuilder(numBits);
        for (int i = 0; i < length - 1; ++i) {
            int next = this.bi.next();
            for (int j = 7; j >= 0 && k < numBits; ++k, --j) {
                if ((next & 1 << j) != 0) {
                    result.append("1");
                    continue;
                }
                result.append("0");
            }
        }
        return result.toString();
    }

    @Override
    public String decodePrintableString() throws ASN1Exception {
        return new String(this.decodePrintableStringAsBytes(), StandardCharsets.US_ASCII);
    }

    @Override
    public byte[] decodePrintableStringAsBytes() throws ASN1Exception {
        this.readTag(19);
        int length = this.readLength();
        int c = 0;
        byte[] result = new byte[length];
        while (this.bi.hasNext() && c < length) {
            int b = this.bi.next();
            ASN1.validatePrintableByte(b);
            result[c++] = (byte)b;
        }
        if (c < length) {
            throw new ASN1Exception("Unexpected end of input");
        }
        return result;
    }

    @Override
    public String decodeObjectIdentifier() throws ASN1Exception {
        this.readTag(6);
        int length = this.readLength();
        long value = 0L;
        BigInteger bigInt = null;
        boolean processedFirst = false;
        StringBuilder objectIdentifierStr = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int octet = this.bi.next();
            if (value < 0x80000000000000L) {
                value = (value << 7) + (long)(octet & 0x7F);
                if ((octet & 0x80) != 0) continue;
                if (!processedFirst) {
                    int first = (int)value / 40;
                    if (first == 0) {
                        objectIdentifierStr.append("0");
                    } else if (first == 1) {
                        value -= 40L;
                        objectIdentifierStr.append("1");
                    } else if (first == 2) {
                        value -= 80L;
                        objectIdentifierStr.append("2");
                    }
                    processedFirst = true;
                }
                objectIdentifierStr.append('.');
                objectIdentifierStr.append(value);
                value = 0L;
                continue;
            }
            if (bigInt == null) {
                bigInt = BigInteger.valueOf(value);
            }
            bigInt = bigInt.shiftLeft(7).add(BigInteger.valueOf(octet & 0x7F));
            if ((octet & 0x80) != 0) continue;
            objectIdentifierStr.append('.');
            objectIdentifierStr.append(bigInt);
            bigInt = null;
            value = 0L;
        }
        return objectIdentifierStr.toString();
    }

    @Override
    public void decodeNull() throws ASN1Exception {
        this.readTag(5);
        int length = this.readLength();
        if (length != 0) {
            throw new ASN1Exception("Non-zero length encountered for null type tag");
        }
    }

    @Override
    public void decodeImplicit(int number) {
        this.decodeImplicit(128, number);
    }

    @Override
    public void decodeImplicit(int clazz, int number) {
        if (this.implicitTag == -1) {
            this.implicitTag = clazz | number;
        }
    }

    @Override
    public boolean isNextType(int clazz, int number, boolean isConstructed) {
        try {
            return this.peekType() == (clazz | (isConstructed ? 32 : 0) | number);
        }
        catch (ASN1Exception e) {
            return false;
        }
    }

    @Override
    public int peekType() throws ASN1Exception {
        int currOffset = this.bi.offset();
        int tag = this.readTag();
        while (this.bi.offset() != currOffset && this.bi.hasPrev()) {
            this.bi.prev();
        }
        return tag;
    }

    @Override
    public void skipElement() throws ASN1Exception {
        int i;
        this.readTag();
        int length = this.readLength();
        for (i = 0; i < length && this.bi.hasNext(); ++i) {
            this.bi.next();
        }
        if (i != length) {
            throw new ASN1Exception("Unexpected end of input");
        }
    }

    @Override
    public boolean hasNextElement() {
        DecoderState lastState = this.states.peekLast();
        boolean hasNext = lastState != null ? this.bi.offset() < lastState.getNextElementIndex() && this.hasCompleteElement() : this.hasCompleteElement();
        return hasNext;
    }

    private boolean hasCompleteElement() {
        boolean hasNext;
        int currOffset = this.bi.offset();
        try {
            int i;
            this.readTag();
            int length = this.readLength();
            for (i = 0; i < length && this.bi.hasNext(); ++i) {
                this.bi.next();
            }
            hasNext = i == length;
        }
        catch (ASN1Exception e) {
            hasNext = false;
        }
        while (this.bi.offset() != currOffset && this.bi.hasPrev()) {
            this.bi.prev();
        }
        return hasNext;
    }

    @Override
    public byte[] drainElementValue() throws ASN1Exception {
        if (this.implicitTag != -1) {
            this.implicitTag = -1;
        }
        this.readTag();
        int length = this.readLength();
        byte[] value = new byte[length];
        if (length != 0 && this.bi.drain(value) != length) {
            throw new ASN1Exception("Unexpected end of input");
        }
        return value;
    }

    @Override
    public byte[] drainElement() throws ASN1Exception {
        if (this.implicitTag != -1) {
            this.implicitTag = -1;
        }
        int currOffset = this.bi.offset();
        this.readTag();
        int valueLength = this.readLength();
        int length = this.bi.offset() - currOffset + valueLength;
        while (this.bi.offset() != currOffset && this.bi.hasPrev()) {
            this.bi.prev();
        }
        byte[] element = new byte[length];
        if (length != 0 && this.bi.drain(element) != length) {
            throw new ASN1Exception("Unexpected end of input");
        }
        return element;
    }

    private int readTag() throws ASN1Exception {
        try {
            int tag = this.bi.next();
            int tagClass = tag & 0xC0;
            int constructed = tag & 0x20;
            int tagNumber = tag & 0x1F;
            if (tagNumber == 31) {
                tagNumber = 0;
                int octet = this.bi.next();
                if ((octet & 0x7F) == 0) {
                    throw new ASN1Exception("Invalid high-tag-number form");
                }
                while (octet >= 0 && (octet & 0x80) != 0) {
                    tagNumber |= octet & 0x7F;
                    tagNumber <<= 7;
                    octet = this.bi.next();
                }
                tagNumber |= octet & 0x7F;
            }
            return tagClass | constructed | tagNumber;
        }
        catch (NoSuchElementException e) {
            throw new ASN1Exception("Unexpected end of input");
        }
    }

    private void readTag(int expectedTag) throws ASN1Exception {
        if (this.implicitTag != -1) {
            expectedTag = this.implicitTag | expectedTag & 0x20;
            this.implicitTag = -1;
        }
        int currOffset = this.bi.offset();
        int actualTag = this.readTag();
        if (actualTag != expectedTag) {
            while (this.bi.offset() != currOffset && this.bi.hasPrev()) {
                this.bi.prev();
            }
            throw new ASN1Exception("Unexpected ASN.1 tag encountered");
        }
    }

    private int readLength() throws ASN1Exception {
        try {
            int length = this.bi.next();
            if (length > 127) {
                int numOctets = length & 0x7F;
                if (numOctets > 4) {
                    throw new ASN1Exception("Length encoding exceeds 4 bytes");
                }
                length = 0;
                for (int i = 0; i < numOctets; ++i) {
                    int nextOctet = this.bi.next();
                    length = (length << 8) + nextOctet;
                }
            }
            return length;
        }
        catch (NoSuchElementException e) {
            throw new ASN1Exception("Unexpected end of input");
        }
    }

    private class DecoderState {
        private final int tag;
        private final int nextElementIndex;

        public DecoderState(int tag, int nextElementIndex) {
            this.tag = tag;
            this.nextElementIndex = nextElementIndex;
        }

        public int getTag() {
            return this.tag;
        }

        public int getNextElementIndex() {
            return this.nextElementIndex;
        }
    }
}

