/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.net.URI;
import org.wildfly.security.auth.MatchRule;

class MatchPathRule
extends MatchRule {
    private final String pathSpec;

    MatchPathRule(MatchRule parent, String pathSpec) {
        super(parent);
        this.pathSpec = pathSpec.endsWith("/") ? pathSpec : pathSpec + "/";
    }

    @Override
    public boolean matches(URI uri) {
        return uri.isAbsolute() && this.prefixes(uri.getPath()) && super.matches(uri);
    }

    @Override
    MatchRule reparent(MatchRule newParent) {
        return new MatchPathRule(newParent, this.pathSpec);
    }

    @Override
    boolean halfEqual(MatchRule other) {
        return this.pathSpec.equals(other.getMatchPath()) && this.parentHalfEqual(other);
    }

    @Override
    public String getMatchPath() {
        return this.pathSpec;
    }

    @Override
    public boolean isPathMatched() {
        return true;
    }

    @Override
    public int hashCode() {
        return 3923 * this.pathSpec.hashCode() + this.parentHashCode();
    }

    private boolean prefixes(String pathSpec) {
        if (pathSpec == null) {
            pathSpec = "/";
        }
        if (!pathSpec.startsWith("/")) {
            pathSpec = "/" + pathSpec;
        }
        if (!pathSpec.endsWith("/")) {
            pathSpec = pathSpec + "/";
        }
        return pathSpec.startsWith(this.pathSpec);
    }

    @Override
    StringBuilder asString(StringBuilder b) {
        return this.parentAsString(b).append("path=~").append(this.pathSpec).append(',');
    }
}

