/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.io.IOException;
import java.util.ArrayList;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.auth.AuthenticationConfiguration;
import org.wildfly.security.auth.SetAnonymousAuthenticationConfiguration;
import org.wildfly.security.auth.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.SetKeyStoreCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.SetNamePrincipalAuthenticationConfiguration;
import org.wildfly.security.auth.SetPasswordAuthenticationConfiguration;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.CredentialParameterCallback;

class SetPasswordCallbackHandlerAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final CallbackHandler callbackHandler;

    SetPasswordCallbackHandlerAuthenticationConfiguration(AuthenticationConfiguration parent, CallbackHandler callbackHandler) {
        super(parent.without(SetCallbackHandlerAuthenticationConfiguration.class).without(SetNamePrincipalAuthenticationConfiguration.class).without(SetPasswordAuthenticationConfiguration.class).without(SetKeyStoreCredentialAuthenticationConfiguration.class).without(SetAnonymousAuthenticationConfiguration.class));
        this.callbackHandler = callbackHandler;
    }

    @Override
    void handleCallbacks(AuthenticationConfiguration config, Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        ArrayList<Callback> list = null;
        for (Callback callback : callbacks) {
            if (!(callback instanceof PasswordCallback) && !(callback instanceof CredentialCallback) && !(callback instanceof CredentialParameterCallback)) continue;
            if (list == null) {
                list = new ArrayList<Callback>(callbacks.length);
            }
            list.add(callback);
        }
        if (list != null) {
            this.callbackHandler.handle(list.toArray(new Callback[list.size()]));
        }
        super.handleCallbacks(config, callbacks);
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        Callback callback = callbacks[index];
        if (callback instanceof PasswordCallback || callback instanceof CredentialCallback || callback instanceof CredentialParameterCallback) {
            return;
        }
        super.handleCallback(callbacks, index);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetPasswordCallbackHandlerAuthenticationConfiguration(newParent, this.callbackHandler);
    }
}

