/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.callback;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.wildfly.security.auth.callback.ExtendedCallback;

public class CredentialCallback
implements ExtendedCallback {
    private final Set<Class<?>> allowedTypes;
    private Object credential;

    public CredentialCallback(Class<?> ... allowedTypes) {
        if (allowedTypes.length == 0) {
            this.allowedTypes = Collections.emptySet();
        } else if (allowedTypes.length == 1) {
            this.allowedTypes = Collections.singleton(allowedTypes[0]);
        } else {
            LinkedHashSet set = new LinkedHashSet(allowedTypes.length);
            Collections.addAll(set, allowedTypes);
            this.allowedTypes = Collections.unmodifiableSet(set);
        }
    }

    public CredentialCallback(Object credential, Class<?> ... allowedTypes) {
        this(allowedTypes);
        this.credential = credential;
    }

    public Object getCredential() {
        return this.credential;
    }

    public void setCredential(Object credential) {
        if (!this.isCredentialSupported(credential)) {
            throw new IllegalArgumentException("Invalid credential type specified");
        }
        this.credential = credential;
    }

    public boolean isCredentialSupported(Object credential) {
        return credential != null && this.isCredentialTypeSupported(credential.getClass());
    }

    public boolean isCredentialTypeSupported(Class<?> credentialType) {
        return credentialType != null && (this.allowedTypes.contains(credentialType) || this.isCredentialTypeSupported(credentialType.getSuperclass()) || this.isCredentialTypeSupportedArray(credentialType.getInterfaces()));
    }

    private boolean isCredentialTypeSupportedArray(Class<?> ... credentialTypes) {
        for (Class<?> credentialType : credentialTypes) {
            if (!this.isCredentialTypeSupported(credentialType)) continue;
            return true;
        }
        return false;
    }

    public Set<Class<?>> getAllowedTypes() {
        return this.allowedTypes;
    }

    @Override
    public boolean isOptional() {
        return this.credential != null;
    }

    @Override
    public boolean needsInformation() {
        return true;
    }
}

