/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.login;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLServerSocketFactory;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.login.SecurityIdentity;
import org.wildfly.security.auth.login.ServerAuthenticationContext;
import org.wildfly.security.auth.spi.CredentialSupport;
import org.wildfly.security.auth.spi.RealmIdentity;
import org.wildfly.security.auth.spi.RealmUnavailableException;
import org.wildfly.security.auth.spi.SecurityRealm;
import org.wildfly.security.auth.spi.SupportLevel;
import org.wildfly.security.auth.util.NameRewriter;
import org.wildfly.security.auth.util.RealmMapper;
import org.wildfly.security.util._private.UnmodifiableArrayList;

public final class SecurityDomain {
    private final Map<String, SecurityRealm> realmMap;
    private final String defaultRealmName;
    private final NameRewriter[] preRealmRewriters;
    private final RealmMapper realmMapper;
    private final NameRewriter[] postRealmRewriters;
    private final boolean anonymousAllowed;
    private final ThreadLocal<SecurityIdentity> currentSecurityIdentity = new ThreadLocal();

    SecurityDomain(Map<String, SecurityRealm> realmMap, String defaultRealmName, NameRewriter[] preRealmRewriters, RealmMapper realmMapper, NameRewriter[] postRealmRewriters) {
        assert (realmMap.containsKey(defaultRealmName));
        this.realmMap = realmMap;
        this.defaultRealmName = defaultRealmName;
        this.preRealmRewriters = preRealmRewriters;
        this.realmMapper = realmMapper;
        this.postRealmRewriters = postRealmRewriters;
        this.anonymousAllowed = false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ServerAuthenticationContext createNewAuthenticationContext() {
        return new ServerAuthenticationContext(this);
    }

    public RealmIdentity mapName(String name) throws RealmUnavailableException {
        SecurityRealm securityRealm;
        for (NameRewriter rewriter : this.preRealmRewriters) {
            name = rewriter.rewriteName(name);
        }
        String realmName = this.realmMapper.getRealmMapping(name);
        if (realmName == null) {
            realmName = this.defaultRealmName;
        }
        if ((securityRealm = this.realmMap.get(realmName)) == null) {
            securityRealm = this.realmMap.get(this.defaultRealmName);
        }
        assert (securityRealm != null);
        for (NameRewriter rewriter : this.postRealmRewriters) {
            name = rewriter.rewriteName(name);
        }
        return securityRealm.createRealmIdentity(name);
    }

    public SSLServerSocketFactory getSslServerSocketFactory() {
        throw new UnsupportedOperationException();
    }

    public List<String> getSaslServerMechanismNames(SaslServerFactory saslServerFactory) {
        String[] names = saslServerFactory.getMechanismNames(Collections.singletonMap("wildfly.sasl.mechanism-query-all", "true"));
        if (names == null || names.length == 0) {
            return Collections.emptyList();
        }
        if (names.length == 1) {
            return Collections.singletonList(names[0]);
        }
        return new UnmodifiableArrayList<String>(names);
    }

    public boolean isAnonymousAllowed() {
        return this.anonymousAllowed;
    }

    SecurityRealm getRealm(String realmName) {
        SecurityRealm securityRealm = this.realmMap.get(realmName);
        if (securityRealm == null) {
            securityRealm = this.realmMap.get(this.defaultRealmName);
        }
        return securityRealm;
    }

    CredentialSupport getCredentialSupport(Class<?> credentialType) {
        SupportLevel verifyMax = null;
        SupportLevel verifyMin = null;
        SupportLevel obtainMax = null;
        SupportLevel obtainMin = null;
        Iterator<SecurityRealm> iterator = this.realmMap.values().iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                SecurityRealm realm = iterator.next();
                try {
                    CredentialSupport support = realm.getCredentialSupport(credentialType);
                    SupportLevel obtainable = support.obtainableSupportLevel();
                    SupportLevel verification = support.verificationSupportLevel();
                    if (obtainMin == null || obtainMax == null || verifyMin == null || verifyMax == null) {
                        obtainMin = obtainMax = obtainable;
                        verifyMin = verifyMax = verification;
                        continue;
                    }
                    if (obtainable.compareTo(obtainMin) < 0) {
                        obtainMin = obtainable;
                    }
                    if (obtainable.compareTo(obtainMax) > 0) {
                        obtainMax = obtainable;
                    }
                    if (verification.compareTo(verifyMin) < 0) {
                        verifyMin = verification;
                    }
                    if (verification.compareTo(verifyMax) <= 0) continue;
                    verifyMax = verification;
                }
                catch (RealmUnavailableException realmUnavailableException) {}
            }
            if (obtainMin == null || obtainMax == null || verifyMin == null || verifyMax == null) {
                return CredentialSupport.UNSUPPORTED;
            }
            return CredentialSupport.getCredentialSupport(this.minMax(obtainMin, obtainMax), this.minMax(verifyMin, verifyMax));
        }
        return CredentialSupport.UNSUPPORTED;
    }

    private SupportLevel minMax(SupportLevel min, SupportLevel max) {
        if (min == max) {
            return min;
        }
        if (max == SupportLevel.UNSUPPORTED) {
            return SupportLevel.UNSUPPORTED;
        }
        if (min == SupportLevel.SUPPORTED) {
            return SupportLevel.SUPPORTED;
        }
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    CredentialSupport getCredentialSupport(String realmName, Class<?> credentialType) {
        SecurityRealm realm = this.getRealm(realmName);
        try {
            return realm.getCredentialSupport(credentialType);
        }
        catch (RealmUnavailableException e) {
            return CredentialSupport.UNSUPPORTED;
        }
    }

    SecurityIdentity getCurrentSecurityIdentity() {
        return this.currentSecurityIdentity.get();
    }

    SecurityIdentity getAndSetCurrentSecurityIdentity(SecurityIdentity newIdentity) {
        try {
            SecurityIdentity securityIdentity = this.currentSecurityIdentity.get();
            return securityIdentity;
        }
        finally {
            this.currentSecurityIdentity.set(newIdentity);
        }
    }

    void setCurrentSecurityIdentity(SecurityIdentity newIdentity) {
        this.currentSecurityIdentity.set(newIdentity);
    }

    public static final class Builder {
        private static final NameRewriter[] NONE = new NameRewriter[0];
        private boolean built = false;
        private final ArrayList<NameRewriter> preRealmRewriters = new ArrayList();
        private final ArrayList<NameRewriter> postRealmRewriters = new ArrayList();
        private final HashMap<String, SecurityRealm> realms = new HashMap();
        private String defaultRealmName;
        private RealmMapper realmMapper = RealmMapper.DEFAULT_REALM_MAPPER;

        public Builder addPreRealmRewriter(NameRewriter rewriter) {
            this.assertNotBuilt();
            if (rewriter != null) {
                this.preRealmRewriters.add(rewriter);
            }
            return this;
        }

        public Builder addPostRealmRewriter(NameRewriter rewriter) {
            this.assertNotBuilt();
            if (rewriter != null) {
                this.postRealmRewriters.add(rewriter);
            }
            return this;
        }

        public Builder setRealmMapper(RealmMapper realmMapper) {
            this.assertNotBuilt();
            this.realmMapper = realmMapper == null ? RealmMapper.DEFAULT_REALM_MAPPER : realmMapper;
            return this;
        }

        public Builder addRealm(String name, SecurityRealm realm) {
            this.assertNotBuilt();
            if (name == null) {
                throw ElytronMessages.log.nullParameter("name");
            }
            if (realm == null) {
                throw ElytronMessages.log.nullParameter("realm");
            }
            this.realms.put(name, realm);
            return this;
        }

        public String getDefaultRealmName() {
            return this.defaultRealmName;
        }

        public Builder setDefaultRealmName(String defaultRealmName) {
            this.assertNotBuilt();
            if (defaultRealmName == null) {
                throw ElytronMessages.log.nullParameter("defaultRealmName");
            }
            this.defaultRealmName = defaultRealmName;
            return this;
        }

        public SecurityDomain build() {
            String defaultRealmName = this.defaultRealmName;
            if (defaultRealmName == null) {
                throw ElytronMessages.log.nullParameter("defaultRealmName");
            }
            HashMap<String, SecurityRealm> realmMap = new HashMap<String, SecurityRealm>(this.realms);
            if (!realmMap.containsKey(defaultRealmName)) {
                throw ElytronMessages.log.realmMapDoesntContainDefault(defaultRealmName);
            }
            this.assertNotBuilt();
            this.built = true;
            NameRewriter[] preRealm = this.preRealmRewriters.isEmpty() ? NONE : this.preRealmRewriters.toArray(new NameRewriter[this.preRealmRewriters.size()]);
            NameRewriter[] postRealm = this.postRealmRewriters.isEmpty() ? NONE : this.postRealmRewriters.toArray(new NameRewriter[this.postRealmRewriters.size()]);
            return new SecurityDomain(realmMap, defaultRealmName, preRealm, this.realmMapper, postRealm);
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw ElytronMessages.log.builderAlreadyBuilt();
            }
        }
    }
}

