/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactorySpi;

public final class PasswordFactory {
    private final Provider provider;
    private final String algorithm;
    private final PasswordFactorySpi spi;

    private PasswordFactory(Provider provider, String algorithm, PasswordFactorySpi spi) {
        this.provider = provider;
        this.algorithm = algorithm;
        this.spi = spi;
    }

    public static PasswordFactory getInstance(String algorithm) throws NoSuchAlgorithmException {
        for (Provider provider : Security.getProviders()) {
            Provider.Service service = provider.getService("PasswordFactory", algorithm);
            if (service == null) continue;
            return new PasswordFactory(provider, algorithm, (PasswordFactorySpi)service.newInstance(null));
        }
        throw new NoSuchAlgorithmException();
    }

    public static PasswordFactory getInstance(String algorithm, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException(providerName);
        }
        return PasswordFactory.getInstance(algorithm, provider);
    }

    public static PasswordFactory getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Provider.Service service = provider.getService("PasswordFactory", algorithm);
        if (service == null) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        return new PasswordFactory(provider, algorithm, (PasswordFactorySpi)service.newInstance(null));
    }

    public Provider getProvider() {
        return this.provider;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public Password generatePassword(KeySpec keySpec) throws InvalidKeySpecException {
        return this.spi.engineGeneratePassword(this.algorithm, keySpec);
    }

    public <T extends KeySpec> T getKeySpec(Password password, Class<T> specType) throws InvalidKeySpecException {
        return this.spi.engineGetKeySpec(this.algorithm, password, specType);
    }

    public <T extends KeySpec> boolean convertibleToKeySpec(Password password, Class<T> specType) {
        return this.spi.engineConvertibleToKeySpec(this.algorithm, password, specType);
    }

    public boolean isTranslatable(Password password) {
        return this.spi.engineIsTranslatablePassword(this.algorithm, password);
    }

    public Password translate(Password password) throws InvalidKeyException {
        return this.spi.engineTranslatePassword(this.algorithm, password);
    }

    public boolean verify(Password password, char[] guess) throws InvalidKeyException {
        return this.spi.engineVerify(this.algorithm, password, guess);
    }
}

