/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.wildfly.security.util._private.Arrays2;

public class CharacterArrayReader
extends CharArrayReader {
    public CharacterArrayReader(char[] buf) {
        super(buf);
    }

    public CharacterArrayReader(char[] buf, int offset, int length) {
        super(buf, offset, length);
    }

    public CharacterArrayReader(char[] buf, int offset) {
        super(buf, offset, buf.length - offset);
    }

    @Override
    public int read() throws IOException, NoSuchElementException {
        int ch = super.read();
        if (ch == -1) {
            throw new NoSuchElementException();
        }
        return ch;
    }

    @Override
    public int read(char[] b, int off, int len) throws IOException, NoSuchElementException {
        int ch = super.read(b, off, len);
        if (ch == -1) {
            throw new NoSuchElementException();
        }
        return ch;
    }

    public int distanceTo(int ch) {
        int p = 0;
        while (this.pos + p < this.buf.length) {
            if (this.buf[p + this.pos] == ch) {
                return p;
            }
            ++p;
        }
        return -1;
    }

    public boolean contentEquals(String other) {
        return Arrays2.equals(this.buf, this.pos, other);
    }
}

