/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500;

import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security.asn1.DERDecoder;

public final class X500PrincipalUtil {
    private static final String[] NO_STRINGS = new String[0];

    private X500PrincipalUtil() {
    }

    public static String[] getAttributeValues(X500Principal principal, String oid) {
        DERDecoder decoder = new DERDecoder(principal.getEncoded());
        String[] strings = NO_STRINGS;
        int len = 0;
        decoder.startSequence();
        while (decoder.hasNextElement()) {
            decoder.startSet();
            while (decoder.hasNextElement()) {
                decoder.startSequence();
                String testOid = decoder.decodeObjectIdentifier();
                if (oid.equals(testOid)) {
                    switch (decoder.peekType()) {
                        case 22: {
                            if (strings.length == len) {
                                strings = Arrays.copyOf(strings, Math.max(2, strings.length) * 2);
                            }
                            strings[len++] = decoder.decodeIA5String();
                            break;
                        }
                        case 19: {
                            if (strings.length == len) {
                                strings = Arrays.copyOf(strings, Math.max(2, strings.length) * 2);
                            }
                            strings[len++] = decoder.decodePrintableString();
                            break;
                        }
                        default: {
                            decoder.skipElement();
                            break;
                        }
                    }
                } else {
                    decoder.skipElement();
                }
                decoder.endSequence();
            }
            decoder.endSet();
        }
        decoder.endSequence();
        if (decoder.hasNextElement()) {
            throw new IllegalArgumentException("Unexpected trailing garbage in X.500 principal");
        }
        String[] result = len == 0 ? NO_STRINGS : new String[len];
        for (int i = 0; i < len; ++i) {
            result[len - i - 1] = strings[i];
        }
        return result;
    }
}

