/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.net.URL;
import java.security.PrivateKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCertificateCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetGSSCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetKeyManagerCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetKeyStoreCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetPasswordAuthenticationConfiguration;

class SetCertificateURLCredentialAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final PrivateKey privateKey;
    private final URL certificateUrl;

    SetCertificateURLCredentialAuthenticationConfiguration(AuthenticationConfiguration parent, PrivateKey privateKey, URL certificateUrl) {
        super(parent.without(SetPasswordAuthenticationConfiguration.class).without(SetCallbackHandlerAuthenticationConfiguration.class).without(SetGSSCredentialAuthenticationConfiguration.class).without(SetKeyStoreCredentialAuthenticationConfiguration.class).without(SetKeyManagerCredentialAuthenticationConfiguration.class).without(SetCertificateCredentialAuthenticationConfiguration.class));
        Assert.checkNotNullParam((String)"privateKey", (Object)privateKey);
        Assert.checkNotNullParam((String)"certificateUrl", (Object)certificateUrl);
        this.privateKey = privateKey;
        this.certificateUrl = certificateUrl;
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetCertificateURLCredentialAuthenticationConfiguration(newParent, this.privateKey, this.certificateUrl);
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        Callback callback = callbacks[index];
        if (callback instanceof CredentialCallback) {
            CredentialCallback credentialCallback = (CredentialCallback)callback;
            if (credentialCallback.isCredentialSupported(this.certificateUrl.getClass(), null)) {
                credentialCallback.setCredential(this.certificateUrl);
                return;
            }
            if (credentialCallback.isCredentialSupported(this.privateKey.getClass(), this.privateKey.getAlgorithm())) {
                credentialCallback.setCredential(this.privateKey);
                return;
            }
        }
        super.handleCallback(callbacks, index);
    }
}

