/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.SetAnonymousAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCertificateCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCertificateURLCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetGSSCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetKeyManagerCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetKeyStoreCredentialAuthenticationConfiguration;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;

class SetPasswordAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final Password password;

    SetPasswordAuthenticationConfiguration(AuthenticationConfiguration parent, Password password) {
        super(parent.without(SetCallbackHandlerAuthenticationConfiguration.class).without(SetKeyStoreCredentialAuthenticationConfiguration.class).without(SetAnonymousAuthenticationConfiguration.class).without(SetGSSCredentialAuthenticationConfiguration.class).without(SetKeyManagerCredentialAuthenticationConfiguration.class).without(SetCertificateCredentialAuthenticationConfiguration.class).without(SetCertificateURLCredentialAuthenticationConfiguration.class));
        this.password = password;
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        Callback callback = callbacks[index];
        if (callback instanceof CredentialCallback) {
            CredentialCallback credentialCallback = (CredentialCallback)callback;
            if (credentialCallback.isCredentialSupported(this.password.getClass(), this.password.getAlgorithm())) {
                credentialCallback.setCredential(this.password);
                return;
            }
        } else if (callback instanceof PasswordCallback && this.password instanceof TwoWayPassword) {
            try {
                PasswordFactory passwordFactory = PasswordFactory.getInstance(this.password.getAlgorithm());
                ClearPasswordSpec clearPasswordSpec = passwordFactory.getKeySpec(this.password, ClearPasswordSpec.class);
                ((PasswordCallback)callback).setPassword(clearPasswordSpec.getEncodedPassword());
                return;
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
        }
        super.handleCallback(callbacks, index);
    }

    @Override
    void configureSaslProperties(Map<String, Object> properties) {
        properties.put("javax.security.sasl.credentials", this.password);
        super.configureSaslProperties(properties);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetPasswordAuthenticationConfiguration(newParent, this.password);
    }
}

