/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.ldap;

import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.provider.ldap.CredentialLoader;
import org.wildfly.security.auth.provider.ldap.DirContextFactory;
import org.wildfly.security.auth.provider.ldap.IdentityCredentialLoader;
import org.wildfly.security.auth.provider.ldap.UserPasswordPasswordUtil;
import org.wildfly.security.auth.server.CredentialSupport;
import org.wildfly.security.password.Password;

class UserPasswordCredentialLoader
implements CredentialLoader {
    static final String DEFAULT_USER_PASSWORD_ATTRIBUTE_NAME = "userPassword";
    static Map<String, CredentialSupport> DEFAULT_CREDENTIAL_SUPPORT = new HashMap<String, CredentialSupport>();
    private final String userPasswordAttributeName;

    public UserPasswordCredentialLoader(String userPasswordAttributeName) {
        this.userPasswordAttributeName = userPasswordAttributeName;
    }

    @Override
    public CredentialSupport getCredentialSupport(DirContextFactory contextFactory, String credentialName) {
        String[] credentialNameParts = credentialName.split("-");
        if (credentialNameParts.length < 2 || !credentialNameParts[0].equals(this.userPasswordAttributeName)) {
            return CredentialSupport.UNSUPPORTED;
        }
        CredentialSupport response = DEFAULT_CREDENTIAL_SUPPORT.get(credentialNameParts[1]);
        if (response == null) {
            return CredentialSupport.UNSUPPORTED;
        }
        return response;
    }

    @Override
    public IdentityCredentialLoader forIdentity(DirContextFactory contextFactory, String distinguishedName) {
        return new ForIdentityLoader(contextFactory, distinguishedName);
    }

    static {
        DEFAULT_CREDENTIAL_SUPPORT.put("clear", CredentialSupport.UNKNOWN);
        DEFAULT_CREDENTIAL_SUPPORT.put("md5", CredentialSupport.UNKNOWN);
        DEFAULT_CREDENTIAL_SUPPORT.put("sha1", CredentialSupport.UNKNOWN);
        DEFAULT_CREDENTIAL_SUPPORT.put("sha256", CredentialSupport.UNKNOWN);
        DEFAULT_CREDENTIAL_SUPPORT.put("sha384", CredentialSupport.UNKNOWN);
        DEFAULT_CREDENTIAL_SUPPORT.put("sha512", CredentialSupport.UNKNOWN);
        DEFAULT_CREDENTIAL_SUPPORT.put("smd5", CredentialSupport.UNKNOWN);
        DEFAULT_CREDENTIAL_SUPPORT.put("ssha", CredentialSupport.UNKNOWN);
        DEFAULT_CREDENTIAL_SUPPORT.put("ssha256", CredentialSupport.UNKNOWN);
        DEFAULT_CREDENTIAL_SUPPORT.put("ssha384", CredentialSupport.UNKNOWN);
        DEFAULT_CREDENTIAL_SUPPORT.put("ssha512", CredentialSupport.UNKNOWN);
        DEFAULT_CREDENTIAL_SUPPORT.put("crypt_", CredentialSupport.UNKNOWN);
        DEFAULT_CREDENTIAL_SUPPORT.put("crypt", CredentialSupport.UNKNOWN);
    }

    private class ForIdentityLoader
    implements IdentityCredentialLoader {
        private final DirContextFactory contextFactory;
        private final String distinguishedName;

        public ForIdentityLoader(DirContextFactory contextFactory, String distinguishedName) {
            this.contextFactory = contextFactory;
            this.distinguishedName = distinguishedName;
        }

        @Override
        public CredentialSupport getCredentialSupport(String credentialName) {
            Object credential = this.getCredential(credentialName, Object.class);
            if (credential != null) {
                return CredentialSupport.FULLY_SUPPORTED;
            }
            return CredentialSupport.UNSUPPORTED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <C> C getCredential(String credentialName, Class<C> credentialType) {
            DirContext context = null;
            String[] credentialNameParts = credentialName.split("-");
            if (credentialNameParts.length < 2) {
                if (ElytronMessages.log.isTraceEnabled()) {
                    ElytronMessages.log.trace("User-password credential name \"" + credentialName + "\" is not in attribute-type form - not supported by LDAP realm");
                }
                return null;
            }
            try {
                context = this.contextFactory.obtainDirContext(null);
                Attributes attributes = context.getAttributes(this.distinguishedName, new String[]{credentialNameParts[0]});
                Attribute attribute = attributes.get(credentialNameParts[0]);
                for (int i = 0; i < attribute.size(); ++i) {
                    byte[] value = (byte[])attribute.get(i);
                    Password password = UserPasswordPasswordUtil.parseUserPassword(value, credentialNameParts[1]);
                    if (!credentialType.isInstance(password)) continue;
                    C c = credentialType.cast(password);
                    return c;
                }
            }
            catch (InvalidKeySpecException | NamingException e) {
                if (ElytronMessages.log.isTraceEnabled()) {
                    ElytronMessages.log.trace("Getting user-password credential " + credentialType.getName() + " failed. dn=" + this.distinguishedName, e);
                }
            }
            finally {
                this.contextFactory.returnContext(context);
            }
            return null;
        }
    }
}

