/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.CredentialSupport;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;

public interface RealmIdentity {
    public static final RealmIdentity ANONYMOUS = new RealmIdentity(){

        public String getName() {
            return "anonymous";
        }

        @Override
        public CredentialSupport getCredentialSupport(String credentialName) throws RealmUnavailableException {
            return CredentialSupport.UNSUPPORTED;
        }

        @Override
        public <C> C getCredential(String credentialName, Class<C> credentialType) throws RealmUnavailableException {
            return null;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return true;
        }
    };
    public static final RealmIdentity NON_EXISTENT = new RealmIdentity(){

        @Override
        public CredentialSupport getCredentialSupport(String credentialName) throws RealmUnavailableException {
            return CredentialSupport.UNSUPPORTED;
        }

        @Override
        public <C> C getCredential(String credentialName, Class<C> credentialType) throws RealmUnavailableException {
            return null;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return false;
        }
    };

    public CredentialSupport getCredentialSupport(String var1) throws RealmUnavailableException;

    public <C> C getCredential(String var1, Class<C> var2) throws RealmUnavailableException;

    default public boolean verifyCredential(String credentialName, Object guess) throws RealmUnavailableException {
        char[] passwordGuess;
        if (guess instanceof char[]) {
            passwordGuess = (char[])guess;
        } else if (guess instanceof String) {
            passwordGuess = ((String)guess).toCharArray();
        } else {
            return false;
        }
        Password credential = this.getCredential(credentialName, Password.class);
        if (credential != null) {
            try {
                PasswordFactory passwordFactory = PasswordFactory.getInstance(credential.getAlgorithm());
                Password translated = passwordFactory.translate(credential);
                return passwordFactory.verify(translated, passwordGuess);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                return false;
            }
        }
        return false;
    }

    public boolean exists() throws RealmUnavailableException;

    default public void dispose() {
    }

    default public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
        if (this.exists()) {
            return AuthorizationIdentity.EMPTY;
        }
        throw ElytronMessages.log.userDoesNotExist();
    }
}

