/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.Collections;
import java.util.List;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.util._private.UnmodifiableArrayList;

public final class SecurityDomainSaslConfiguration {
    private final SecurityDomain securityDomain;
    private final SaslServerFactory saslServerFactory;

    public SecurityDomainSaslConfiguration(SecurityDomain securityDomain, SaslServerFactory saslServerFactory) {
        this.securityDomain = (SecurityDomain)Assert.checkNotNullParam((String)"securityDomain", (Object)securityDomain);
        Assert.checkNotNullParam((String)"saslServerFactory", (Object)saslServerFactory);
        this.saslServerFactory = saslServerFactory;
    }

    public SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    public SaslServerFactory getSaslServerFactory() {
        return this.saslServerFactory;
    }

    public List<String> getMechanismNames() {
        String[] names = this.saslServerFactory.getMechanismNames(Collections.singletonMap("wildfly.sasl.mechanism-query-all", "true"));
        if (names == null || names.length == 0) {
            return Collections.emptyList();
        }
        if (names.length == 1) {
            return Collections.singletonList(names[0]);
        }
        return new UnmodifiableArrayList<String>(names);
    }
}

