/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.PermissionCollection;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.wildfly.common.Assert;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.ParametricPrivilegedExceptionAction;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.permission.ChangeRoleMapperPermission;
import org.wildfly.security.auth.permission.RunAsPrincipalPermission;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmInfo;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationException;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.RoleMapper;

public final class SecurityIdentity {
    private final SecurityDomain securityDomain;
    private final Principal principal;
    private final AuthorizationIdentity authorizationIdentity;
    private final RealmInfo realmInfo;
    private final Map<String, RoleMapper> roleMappers;

    SecurityIdentity(SecurityDomain securityDomain, Principal principal, RealmInfo realmInfo, AuthorizationIdentity authorizationIdentity, Map<String, RoleMapper> roleMappers) {
        this.securityDomain = securityDomain;
        this.principal = principal;
        this.realmInfo = realmInfo;
        this.authorizationIdentity = authorizationIdentity;
        this.roleMappers = roleMappers;
    }

    SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    RealmInfo getRealmInfo() {
        return this.realmInfo;
    }

    AuthorizationIdentity getAuthorizationIdentity() {
        return this.authorizationIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAs(Runnable action) {
        if (action == null) {
            return;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            action.run();
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAs(Callable<T> action) throws Exception {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.call();
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAs(PrivilegedAction<T> action) {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.run();
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public <T> T runAs(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.run();
            return t;
        }
        catch (RuntimeException | PrivilegedActionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, P> T runAs(P parameter, ParametricPrivilegedAction<T, P> action) {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.run(parameter);
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public <T, P> T runAs(P parameter, ParametricPrivilegedExceptionAction<T, P> action) throws PrivilegedActionException {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.run(parameter);
            return t;
        }
        catch (RuntimeException | PrivilegedActionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public Set<String> getRoles() {
        return this.securityDomain.mapRoles(this);
    }

    public Set<String> getRoles(String category) {
        RoleMapper roleMapper = this.roleMappers.get(category);
        return roleMapper == null ? Collections.emptySet() : roleMapper.mapRoles(this.securityDomain.mapRoles(this));
    }

    public SecurityIdentity withRoleMapper(String category, RoleMapper roleMapper) {
        Map<String, RoleMapper> newMap;
        Assert.checkNotNullParam((String)"category", (Object)category);
        Assert.checkNotNullParam((String)"roleMapper", (Object)roleMapper);
        Map<String, RoleMapper> roleMappers = this.roleMappers;
        RoleMapper existingRoleMapper = roleMappers.get(category);
        if (existingRoleMapper == roleMapper) {
            return this;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ChangeRoleMapperPermission(category));
        }
        if (roleMappers.isEmpty() || roleMappers.size() == 1 && roleMappers.keySet().iterator().next().equals(category)) {
            newMap = Collections.singletonMap(category, roleMapper);
        } else {
            newMap = new HashMap<String, RoleMapper>(roleMappers);
            newMap.put(category, roleMapper);
        }
        return new SecurityIdentity(this.securityDomain, this.principal, this.realmInfo, this.authorizationIdentity, newMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityIdentity createRunAsIdentity(String name) throws AuthorizationException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        SecurityDomain domain = this.securityDomain;
        name = domain.getPreRealmRewriter().rewriteName(name);
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        String realmName = domain.mapRealmName(name);
        NamePrincipal principal = new NamePrincipal(name);
        if (this.principal.equals(principal)) {
            return this;
        }
        RealmInfo realmInfo = domain.getRealmInfo(realmName);
        name = domain.getPostRealmRewriter().rewriteName(name);
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        name = realmInfo.getNameRewriter().rewriteName(name);
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        RunAsPrincipalPermission permission = new RunAsPrincipalPermission(name);
        if (this.getPermissions().implies(permission)) {
            SecurityRealm securityRealm = realmInfo.getSecurityRealm();
            RealmIdentity realmIdentity = securityRealm.createRealmIdentity(name);
            try {
                SecurityIdentity securityIdentity = new SecurityIdentity(domain, principal, realmInfo, realmIdentity.getAuthorizationIdentity(), this.roleMappers);
                realmIdentity.dispose();
                return securityIdentity;
            }
            catch (Throwable throwable) {
                try {
                    realmIdentity.dispose();
                    throw throwable;
                }
                catch (RealmUnavailableException ex) {
                    throw ElytronMessages.log.runAsAuthorizationFailed(this.principal, principal, ex);
                }
            }
        }
        throw ElytronMessages.log.unauthorizedRunAs(this.principal, principal, permission);
    }

    public PermissionCollection getPermissions() {
        return this.securityDomain.mapPermissions(this);
    }

    public Attributes getAttributes() {
        return this.authorizationIdentity.getAttributes().asReadOnly();
    }

    public Principal getPrincipal() {
        return this.principal;
    }
}

