/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.PasswordVerifyCallback;
import org.wildfly.security.auth.callback.SecurityIdentityCallback;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerExchange;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util._private.Arrays2;

class BasicAuthenticationMechanism
implements HttpServerAuthenticationMechanism {
    private static final String BASIC_PREFIX = "Basic ";
    private static final int PREFIX_LENGTH = "Basic ".length();
    private final CallbackHandler callbackHandler;
    private final String challengeValue;

    BasicAuthenticationMechanism(CallbackHandler callbackHandler, String realm, boolean includeCharset) {
        Assert.checkNotNullParam((String)"callbackHandler", (Object)callbackHandler);
        Assert.checkNotNullParam((String)"realm", (Object)realm);
        this.callbackHandler = callbackHandler;
        StringBuilder sb = new StringBuilder(BASIC_PREFIX);
        sb.append("realm").append("=\"").append(realm).append("\"");
        if (includeCharset) {
            sb.append(", ").append("charset").append("=\"UTF-8\"");
        }
        this.challengeValue = sb.toString();
    }

    @Override
    public String getMechanismName() {
        return "Basic";
    }

    @Override
    public boolean evaluateRequest(HttpServerExchange exchange) throws HttpAuthenticationException {
        List<String> authorizationValues = exchange.getRequestHeaderValues("Authorization");
        if (authorizationValues != null) {
            for (String current : authorizationValues) {
                if (!current.startsWith(BASIC_PREFIX)) continue;
                byte[] decodedValue = ByteIterator.ofBytes(current.substring(PREFIX_LENGTH).getBytes(StandardCharsets.UTF_8)).base64Decode().drain();
                int colonPos = Arrays2.indexOf(decodedValue, 58);
                if (colonPos <= 0 || colonPos == decodedValue.length - 1) {
                    throw ElytronMessages.log.incorrectlyFormattedHeader("Authorization");
                }
                ByteBuffer usernameBytes = ByteBuffer.wrap(decodedValue, 0, colonPos);
                ByteBuffer passwordBytes = ByteBuffer.wrap(decodedValue, colonPos + 1, decodedValue.length - colonPos - 1);
                CharBuffer usernameChars = StandardCharsets.UTF_8.decode(usernameBytes);
                CharBuffer passwordChars = StandardCharsets.UTF_8.decode(passwordBytes);
                char[] password = new char[passwordChars.length()];
                passwordChars.get(password);
                try {
                    String username = usernameChars.toString();
                    if (this.authenticate(username, passwordChars.array())) {
                        SecurityIdentityCallback securityIdentityCallback = new SecurityIdentityCallback();
                        this.callbackHandler.handle(new Callback[]{AuthenticationCompleteCallback.SUCCEEDED, securityIdentityCallback});
                        exchange.authenticationComplete(securityIdentityCallback.getSecurityIdentity());
                    } else {
                        this.callbackHandler.handle(new Callback[]{AuthenticationCompleteCallback.FAILED});
                        exchange.authenticationFailed(ElytronMessages.log.authenticationFailed(username, "Basic"));
                    }
                }
                catch (IOException | UnsupportedCallbackException e) {
                    throw new HttpAuthenticationException(e);
                }
                finally {
                    Arrays.fill(password, '\u0000');
                    if (passwordChars.hasArray()) {
                        Arrays.fill(passwordChars.array(), '\u0000');
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean authenticate(String username, char[] password) throws HttpAuthenticationException {
        NameCallback nameCallback = new NameCallback("Remote Authentication Name", username);
        nameCallback.setName(username);
        PasswordVerifyCallback passwordVerifyCallback = new PasswordVerifyCallback(password);
        try {
            this.callbackHandler.handle(new Callback[]{nameCallback, passwordVerifyCallback});
            boolean bl = passwordVerifyCallback.isVerified();
            return bl;
        }
        catch (UnsupportedCallbackException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new HttpAuthenticationException(e);
        }
        finally {
            passwordVerifyCallback.clearPassword();
        }
    }

    @Override
    public boolean prepareResponse(HttpServerExchange exchange) {
        exchange.addResponseHeader("WWW-Authenticate", this.challengeValue);
        exchange.setResponseCode(401);
        return true;
    }
}

