/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.wildfly.common.Assert;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerExchange;

final class PrivilegedServerMechanism
implements HttpServerAuthenticationMechanism {
    private final HttpServerAuthenticationMechanism mechanism;
    private final AccessControlContext accessControlContext;

    PrivilegedServerMechanism(HttpServerAuthenticationMechanism mechanism, AccessControlContext accessControlContext) {
        this.mechanism = (HttpServerAuthenticationMechanism)Assert.checkNotNullParam((String)"mechanism", (Object)mechanism);
        this.accessControlContext = (AccessControlContext)Assert.checkNotNullParam((String)"accessControlContext", (Object)accessControlContext);
    }

    @Override
    public String getMechanismName() {
        return this.mechanism.getMechanismName();
    }

    @Override
    public boolean evaluateRequest(HttpServerExchange exchange) throws HttpAuthenticationException {
        try {
            return AccessController.doPrivileged(() -> this.mechanism.evaluateRequest(exchange), this.accessControlContext);
        }
        catch (PrivilegedActionException pae) {
            try {
                throw pae.getCause();
            }
            catch (Error | RuntimeException | HttpAuthenticationException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
    }

    @Override
    public boolean prepareResponse(HttpServerExchange exchange) throws HttpAuthenticationException {
        try {
            return AccessController.doPrivileged(() -> this.mechanism.prepareResponse(exchange), this.accessControlContext);
        }
        catch (PrivilegedActionException pae) {
            try {
                throw pae.getCause();
            }
            catch (Error | RuntimeException | HttpAuthenticationException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
    }
}

