/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.impl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.ServerCredentialCallback;
import org.wildfly.security.credential.GSSCredentialCredential;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.http.Scope;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism.MechanismUtil;
import org.wildfly.security.util.ByteIterator;

public class SpnegoAuthenticationMechanism
implements HttpServerAuthenticationMechanism {
    private static final String CHALLENGE_PREFIX = "Negotiate ";
    private static final String GSS_CONTEXT_KEY = SpnegoAuthenticationMechanism.class.getName() + ".GSSContext";
    private final CallbackHandler callbackHandler;

    SpnegoAuthenticationMechanism(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public String getMechanismName() {
        return "SPNEGO";
    }

    @Override
    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        GSSContext gssContext;
        HttpScope connectionScope = request.getScope(Scope.CONNECTION);
        GSSContext gSSContext = gssContext = connectionScope != null ? connectionScope.getAttachment(GSS_CONTEXT_KEY, GSSContext.class) : null;
        if (gssContext != null && gssContext.isEstablished() && this.authorizeEstablishedContext(gssContext)) {
            ElytronMessages.log.trace("Successfully authorized using cached identity");
            request.authenticationComplete();
            return;
        }
        if (gssContext == null) {
            Optional challenge;
            GSSCredential gssCredential;
            ServerCredentialCallback gssCredentialCallback = new ServerCredentialCallback(GSSCredentialCredential.class);
            try {
                ElytronMessages.log.trace("Obtaining GSSCredential from callbackHandler...");
                this.callbackHandler.handle(new Callback[]{gssCredentialCallback});
                gssCredential = gssCredentialCallback.applyToCredential(GSSCredentialCredential.class, GSSCredentialCredential::getGssCredential);
            }
            catch (IOException | UnsupportedCallbackException e) {
                throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason("SPNEGO", e).toHttpAuthenticationException();
            }
            if (gssCredential == null) {
                ElytronMessages.log.trace("Obtaining GSSCredential from callbackHandler failed - null credential");
                request.noAuthenticationInProgress();
                return;
            }
            List<String> authorizationValues = request.getRequestHeaderValues("Authorization");
            Optional<Object> optional = challenge = authorizationValues != null ? authorizationValues.stream().filter(s -> s.startsWith(CHALLENGE_PREFIX)).limit(1L).map(s -> s.substring(CHALLENGE_PREFIX.length())).findFirst() : Optional.empty();
            if (ElytronMessages.log.isTraceEnabled()) {
                ElytronMessages.log.tracef("Sent HTTP authorizations: [%s]", authorizationValues == null ? "null" : String.join((CharSequence)", ", authorizationValues));
            }
            if (challenge.isPresent()) {
                ElytronMessages.log.trace("Processing incoming response to a challenge...");
                GSSManager gssManager = GSSManager.getInstance();
                try {
                    gssContext = gssManager.createContext(gssCredential);
                }
                catch (GSSException e) {
                    throw ElytronMessages.log.mechUnableToCreateGssContext("SPNEGO", e).toHttpAuthenticationException();
                }
                if (connectionScope != null) {
                    connectionScope.setAttachment(GSS_CONTEXT_KEY, gssContext);
                }
                byte[] decodedValue = ByteIterator.ofBytes(((String)challenge.get()).getBytes(StandardCharsets.UTF_8)).base64Decode().drain();
                try {
                    byte[] responseToken = gssContext.acceptSecContext(decodedValue, 0, decodedValue.length);
                    if (gssContext.isEstablished()) {
                        ElytronMessages.log.trace("GSSContext established, authorizing...");
                        if (this.authorizeEstablishedContext(gssContext)) {
                            ElytronMessages.log.trace("GSSContext established and authorized - authentication complete");
                            if (responseToken != null) {
                                request.authenticationComplete(response -> this.sendIntermediateChallenge(responseToken, response, true));
                            } else {
                                request.authenticationComplete();
                            }
                            return;
                        }
                        ElytronMessages.log.trace("Authorization of established GSSContext failed");
                        GSSName gssName = gssContext.getSrcName();
                        request.authenticationFailed(ElytronMessages.log.authorizationFailed(gssName == null ? null : gssName.toString(), "SPNEGO"));
                    } else if (responseToken != null) {
                        request.authenticationInProgress(response -> this.sendIntermediateChallenge(responseToken, response, false));
                        return;
                    }
                }
                catch (GSSException e) {
                    ElytronMessages.log.trace(e);
                    try {
                        MechanismUtil.handleCallbacks("SPNEGO", this.callbackHandler, AuthenticationCompleteCallback.FAILED);
                    }
                    catch (UnsupportedCallbackException | AuthenticationMechanismException exception) {
                        // empty catch block
                    }
                    request.authenticationFailed(ElytronMessages.log.authenticationFailed("SPNEGO"), this::sendBareChallenge);
                    return;
                }
            }
        }
        request.noAuthenticationInProgress(this::sendBareChallenge);
    }

    private void sendBareChallenge(HttpServerResponse response) {
        response.addResponseHeader("WWW-Authenticate", "Negotiate");
        response.setStatusCode(401);
    }

    private void sendIntermediateChallenge(byte[] responseToken, HttpServerResponse response, boolean complete) {
        String responseConverted = ByteIterator.ofBytes(responseToken).base64Encode().drainToString();
        response.addResponseHeader("WWW-Authenticate", CHALLENGE_PREFIX + responseConverted);
        if (!complete) {
            response.setStatusCode(401);
        }
    }

    private boolean authorizeEstablishedContext(GSSContext gssContext) throws HttpAuthenticationException {
        assert (gssContext.isEstablished());
        boolean authorized = false;
        try {
            GSSName srcName = gssContext.getSrcName();
            if (srcName == null) {
                ElytronMessages.log.trace("Authorization failed - clientName (name of GSSContext initiator) is null - wrong realm or kdc?");
                return false;
            }
            String clientName = srcName.toString();
            AuthorizeCallback authorize = new AuthorizeCallback(clientName, clientName);
            this.callbackHandler.handle(new Callback[]{authorize});
            authorized = authorize.isAuthorized();
            ElytronMessages.log.tracef("Authorized by callbackHandler = %b  clientName = [%s]", authorized, clientName);
        }
        catch (GSSException e) {
            try {
                MechanismUtil.handleCallbacks("SPNEGO", this.callbackHandler, AuthenticationCompleteCallback.FAILED);
            }
            catch (UnsupportedCallbackException | AuthenticationMechanismException exception) {
                // empty catch block
            }
            throw ElytronMessages.log.mechServerSideAuthenticationFailed("SPNEGO", e).toHttpAuthenticationException();
        }
        catch (IOException e) {
            throw ElytronMessages.log.mechServerSideAuthenticationFailed("SPNEGO", e).toHttpAuthenticationException();
        }
        catch (UnsupportedCallbackException e) {
            // empty catch block
        }
        try {
            MechanismUtil.handleCallbacks("SPNEGO", this.callbackHandler, authorized ? AuthenticationCompleteCallback.SUCCEEDED : AuthenticationCompleteCallback.FAILED);
        }
        catch (AuthenticationMechanismException e) {
            throw e.toHttpAuthenticationException();
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            // empty catch block
        }
        return authorized;
    }
}

