/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import org.wildfly.common.Assert;
import org.wildfly.security.password.OneWayPassword;
import org.wildfly.security.password.interfaces.RawBCryptPassword;

public interface BCryptPassword
extends OneWayPassword {
    public static final String ALGORITHM_BCRYPT = "bcrypt";
    public static final int BCRYPT_SALT_SIZE = 16;
    public static final int BCRYPT_HASH_SIZE = 23;
    public static final int DEFAULT_ITERATION_COUNT = 10;

    public byte[] getHash();

    public byte[] getSalt();

    public int getIterationCount();

    @Override
    public BCryptPassword clone();

    public static BCryptPassword createRaw(String algorithm, byte[] hash, byte[] salt, int iterationCount) {
        Assert.checkNotNullParam((String)"hash", (Object)hash);
        Assert.checkNotNullParam((String)"salt", (Object)salt);
        Assert.checkNotNullParam((String)"algorithm", (Object)algorithm);
        return new RawBCryptPassword(algorithm, (byte[])hash.clone(), (byte[])salt.clone(), iterationCount);
    }
}

