/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;

public abstract class IdentityCredentials
implements Iterable<Credential> {
    public static final IdentityCredentials NONE = new IdentityCredentials(){

        @Override
        IdentityCredentials getNext() {
            return null;
        }

        @Override
        public boolean contains(Class<? extends Credential> credentialType, String algorithmName) {
            return false;
        }

        @Override
        public IdentityCredentials without(Predicate<? super Credential> predicate) {
            return this;
        }

        @Override
        Credential getCredential() {
            return null;
        }

        @Override
        public IdentityCredentials without(Class<? extends Credential> credentialType) {
            return this;
        }

        @Override
        public IdentityCredentials withoutMatching(Credential credential) {
            return this;
        }

        @Override
        public IdentityCredentials without(Class<? extends Credential> credentialType, String algorithmName) {
            return this;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) {
            return null;
        }

        @Override
        public IdentityCredentials with(IdentityCredentials other) {
            return other;
        }

        @Override
        public Iterator<Credential> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public Spliterator<Credential> spliterator() {
            return Spliterators.emptySpliterator();
        }

        @Override
        public int size() {
            return 0;
        }
    };

    IdentityCredentials() {
    }

    public final boolean contains(Class<? extends Credential> credentialType) {
        return this.contains(credentialType, null);
    }

    public abstract boolean contains(Class<? extends Credential> var1, String var2);

    public final boolean containsMatching(Credential credential) {
        Assert.checkNotNullParam((String)"credential", (Object)credential);
        return credential instanceof AlgorithmCredential ? this.contains(credential.getClass(), ((AlgorithmCredential)credential).getAlgorithm()) : this.contains(credential.getClass());
    }

    public final <C extends Credential> C getCredential(Class<C> credentialType) {
        return this.getCredential(credentialType, null);
    }

    public abstract <C extends Credential> C getCredential(Class<C> var1, String var2);

    public final <C extends Credential, R> R applyToCredential(Class<C> credentialType, Function<C, R> function) throws RealmUnavailableException {
        C credential = this.getCredential(credentialType);
        return credential == null ? null : (R)credential.castAndApply(credentialType, function);
    }

    public final <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, Function<C, R> function) throws RealmUnavailableException {
        C credential = this.getCredential(credentialType, algorithmName);
        return credential == null ? null : (R)credential.castAndApply(credentialType, algorithmName, function);
    }

    public final IdentityCredentials withCredential(Credential credential) {
        return new CredentialNode(this.withoutMatching(credential), credential);
    }

    public abstract IdentityCredentials with(IdentityCredentials var1);

    public IdentityCredentials without(Class<? extends Credential> credentialType) {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return this.without(credentialType::isInstance);
    }

    public IdentityCredentials withoutMatching(Credential credential) {
        Assert.checkNotNullParam((String)"credential", (Object)credential);
        return this.without(credential::matches);
    }

    public IdentityCredentials without(Class<? extends Credential> credentialType, String algorithmName) {
        if (algorithmName == null) {
            return this.without(credentialType);
        }
        if (AlgorithmCredential.class.isAssignableFrom(credentialType)) {
            return this.without((? super Credential cred) -> credentialType.isInstance(cred) && algorithmName.equals(((AlgorithmCredential)cred).getAlgorithm()));
        }
        return this;
    }

    public abstract IdentityCredentials without(Predicate<? super Credential> var1);

    @Override
    public Iterator<Credential> iterator() {
        return new Itr(this);
    }

    @Override
    public Spliterator<Credential> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 1297);
    }

    public abstract int size();

    abstract IdentityCredentials getNext();

    abstract Credential getCredential();

    static class CredentialNode
    extends IdentityCredentials {
        private final IdentityCredentials next;
        private final Credential credential;
        private final int size;

        CredentialNode(IdentityCredentials next, Credential credential) {
            this.next = next;
            this.credential = credential;
            this.size = next.size() + 1;
        }

        private CredentialNode withNext(IdentityCredentials next) {
            if (next == this.next) {
                return this;
            }
            return new CredentialNode(next, this.credential);
        }

        @Override
        IdentityCredentials getNext() {
            return this.next;
        }

        @Override
        Credential getCredential() {
            return this.credential;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            Credential credential = this.credential;
            if (credential instanceof AlgorithmCredential) {
                AlgorithmCredential algorithmCredential = (AlgorithmCredential)credential;
                if (credentialType.isInstance(algorithmCredential) && (algorithmName == null || algorithmName.equals(algorithmCredential.getAlgorithm()))) {
                    return (C)((Credential)credentialType.cast(algorithmCredential));
                }
                return this.next.getCredential(credentialType, algorithmName);
            }
            if (algorithmName == null && credentialType.isInstance(credential)) {
                return (C)((Credential)credentialType.cast(credential));
            }
            return this.next.getCredential(credentialType, algorithmName);
        }

        @Override
        public boolean contains(Class<? extends Credential> credentialType, String algorithmName) {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            Credential credential = this.credential;
            if (credential instanceof AlgorithmCredential) {
                return credentialType.isInstance(credential) && algorithmName.equals(((AlgorithmCredential)credential).getAlgorithm());
            }
            return algorithmName == null && credentialType.isInstance(credential);
        }

        @Override
        public IdentityCredentials without(Predicate<? super Credential> predicate) {
            Assert.checkNotNullParam((String)"predicate", predicate);
            if (predicate.test(this.credential)) {
                return this.next.without(predicate);
            }
            return this.withNext(this.next.without(predicate));
        }

        @Override
        public IdentityCredentials with(IdentityCredentials other) {
            if (other == NONE) {
                return this;
            }
            return this.withNext(this.without((? super Credential cred) -> cred instanceof AlgorithmCredential ? other.getCredential(cred.getClass(), ((AlgorithmCredential)cred).getAlgorithm()) != null : other.getCredential(cred.getClass()) != null));
        }
    }

    static class Itr
    implements Iterator<Credential> {
        private IdentityCredentials current;

        Itr(IdentityCredentials current) {
            this.current = current;
        }

        @Override
        public boolean hasNext() {
            return this.current != NONE;
        }

        @Override
        public Credential next() {
            IdentityCredentials current = this.current;
            if (current == NONE) {
                throw new NoSuchElementException();
            }
            try {
                Credential credential = current.getCredential();
                return credential;
            }
            finally {
                this.current = current.getNext();
            }
        }
    }
}

