/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util.sso;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpScopeNotification;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.Scope;
import org.wildfly.security.http.util.sso.SingleSignOnSession;
import org.wildfly.security.http.util.sso.SingleSignOnSessionFactory;
import org.wildfly.security.util.ByteIterator;

public class DefaultSingleSignOnSessionFactory
implements SingleSignOnSessionFactory {
    private static final HostnameVerifier DEFAULT_HOSTNAME_VERIFIER = (s, sslSession) -> true;
    private static final Function<SecurityIdentity, String> DEFAULT_SESSION_IDENTIFIER_FACTORY = identity -> UUID.randomUUID().toString();
    private static final String DEFAULT_SIGNATURE_ALGORITHM = "SHA512withRSA";
    private static final String LOGOUT_REQUEST_PARAMETER = "ely_logout_message";
    private static final String SESSION_INVALIDATING_ATTRIBUTE = DefaultSingleSignOnSessionFactory.class.getName() + ".INVALIDATING";
    private final Map<String, Object> cache;
    private final KeyStore keyStore;
    private final Function<SecurityIdentity, String> identifierFactory;
    private final SSLContext sslContext;
    private final HostnameVerifier hostnameVerifier;
    private final String keyAlias;
    private final String keyPassword;

    public DefaultSingleSignOnSessionFactory(Map<String, Object> cache, KeyStore keyStore, String keyAlias, String keyPassword, SSLContext sslContext) {
        this(cache, keyStore, keyAlias, keyPassword, sslContext, DEFAULT_HOSTNAME_VERIFIER, DEFAULT_SESSION_IDENTIFIER_FACTORY);
    }

    public DefaultSingleSignOnSessionFactory(Map<String, Object> cache, KeyStore keyStore, String keyAlias, String keyPassword, SSLContext sslContext, HostnameVerifier hostnameVerifier, Function<SecurityIdentity, String> identifierFactory) {
        this.cache = (Map)Assert.checkNotNullParam((String)"cache", cache);
        this.keyStore = (KeyStore)Assert.checkNotNullParam((String)"keyStore", (Object)keyStore);
        this.keyAlias = (String)Assert.checkNotNullParam((String)"keyAlias", (Object)keyAlias);
        this.keyPassword = (String)Assert.checkNotNullParam((String)"keyPassword", (Object)keyPassword);
        try {
            Key privateKey = keyStore.getKey(keyAlias, keyPassword.toCharArray());
            if (!(privateKey instanceof PrivateKey) || !"RSA".equals(privateKey.getAlgorithm())) {
                throw ElytronMessages.log.httpMechSsoRSAPrivateKeyExpected(keyAlias);
            }
            Certificate certificate = keyStore.getCertificate(keyAlias);
            if (certificate == null) {
                throw ElytronMessages.log.httpMechSsoCertificateExpected(keyAlias);
            }
        }
        catch (Exception cause) {
            throw ElytronMessages.log.httpMechSsoFailedObtainKeyFromKeyStore(keyAlias, cause);
        }
        this.identifierFactory = (Function)Assert.checkNotNullParam((String)"identifierFactory", identifierFactory);
        this.sslContext = sslContext;
        this.hostnameVerifier = hostnameVerifier;
    }

    @Override
    public SingleSignOnSession findById(final String id, HttpServerRequest request) {
        Assert.checkNotNullParam((String)"id", (Object)id);
        Assert.checkNotNullParam((String)"request", (Object)request);
        if (this.cache.containsKey(id)) {
            ElytronMessages.log.debugf("Found SSO session with ID [%s]", id);
            return new AbstractSingleSignOnSession(request){

                @Override
                public String getId() {
                    return id;
                }

                @Override
                public void put(SecurityIdentity identity) {
                    DefaultSingleSignOnSessionEntry entry = (DefaultSingleSignOnSessionEntry)DefaultSingleSignOnSessionFactory.this.cache.get(this.getId());
                    CachedIdentity cachedIdentity = entry.getCachedIdentity();
                    SecurityIdentity securityIdentity = cachedIdentity.getSecurityIdentity();
                    if (securityIdentity == null) {
                        ElytronMessages.log.debugf("Updating local copy of SSO [%s] with a new identity", id);
                        entry.setCachedIdentity(new CachedIdentity(cachedIdentity.getMechanismName(), identity));
                    }
                    this.addLocalSessionIfNecessary(entry);
                }
            };
        }
        return null;
    }

    @Override
    public SingleSignOnSession create(HttpServerRequest request, final String mechanismName) {
        Assert.checkNotNullParam((String)"request", (Object)request);
        Assert.checkNotNullParam((String)"mechanismName", (Object)mechanismName);
        return new AbstractSingleSignOnSession(request){
            private String id;

            @Override
            public String getId() {
                return this.id;
            }

            @Override
            public void put(SecurityIdentity identity) {
                this.id = (String)DefaultSingleSignOnSessionFactory.this.identifierFactory.apply(identity);
                ElytronMessages.log.debugf("Creating new SSO [%s]", this.id);
                this.addLocalSessionIfNecessary(new DefaultSingleSignOnSessionEntry(new CachedIdentity(mechanismName, identity)));
            }
        };
    }

    @Override
    public void logout(String id) {
        Assert.checkNotNullParam((String)"id", (Object)id);
        ElytronMessages.log.debugf("Performing a single logout for SSO [%s]", id);
        DefaultSingleSignOnSessionEntry entry = (DefaultSingleSignOnSessionEntry)this.cache.get(id);
        entry.getLocalSessions().forEach(localSessionId -> {
            String participant = localSessionId.substring(0, localSessionId.lastIndexOf(":"));
            try {
                URL participantUrl = new URL(participant);
                boolean isHttps = participantUrl.getProtocol().equalsIgnoreCase("https");
                HttpURLConnection connection = (HttpURLConnection)participantUrl.openConnection();
                if (isHttps) {
                    HttpsURLConnection https = (HttpsURLConnection)connection;
                    https.setSSLSocketFactory(this.sslContext.getSocketFactory());
                    https.setHostnameVerifier(this.hostnameVerifier);
                }
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setAllowUserInteraction(false);
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                StringBuilder parameterBuilder = new StringBuilder();
                parameterBuilder.append(LOGOUT_REQUEST_PARAMETER).append("=").append(this.createLogoutRequest((String)localSessionId));
                connection.setRequestProperty("Content-Length", Integer.toString(parameterBuilder.length()));
                try (OutputStream outputStream = connection.getOutputStream();
                     DataOutputStream wr = new DataOutputStream(outputStream);){
                    wr.writeBytes(parameterBuilder.toString());
                }
                connection.getInputStream().close();
            }
            catch (Exception cause) {
                ElytronMessages.log.warnHttpMechSsoFailedLogoutParticipant(participant.toString(), cause);
            }
        });
        this.cache.remove(id);
    }

    private String createLogoutRequest(String localSessionId) throws Exception {
        String participant = localSessionId.substring(0, localSessionId.lastIndexOf(":"));
        String participantSessionId = localSessionId.substring(participant.length() + 1);
        Signature signature = Signature.getInstance(DEFAULT_SIGNATURE_ALGORITHM);
        PrivateKey privateKey = (PrivateKey)this.keyStore.getKey(this.keyAlias, this.keyPassword.toCharArray());
        signature.initSign(privateKey);
        Base64.Encoder urlEncoder = Base64.getUrlEncoder();
        return participantSessionId + "." + ByteIterator.ofBytes(urlEncoder.encode(ByteIterator.ofBytes(participantSessionId.getBytes()).sign(signature).drain())).asUtf8String().drainToString();
    }

    private String verifyLogoutRequest(String logoutRequest) throws Exception {
        String[] actionParts = logoutRequest.split("\\.");
        String localSessionId = ByteIterator.ofBytes(actionParts[0].getBytes()).asUtf8String().drainToString();
        Signature signature = Signature.getInstance(DEFAULT_SIGNATURE_ALGORITHM);
        signature.initVerify(this.keyStore.getCertificate(this.keyAlias));
        signature.update(localSessionId.getBytes());
        Base64.Decoder urlDecoder = Base64.getUrlDecoder();
        boolean verify = ByteIterator.ofBytes(urlDecoder.decode(actionParts[1].getBytes())).verify(signature);
        if (verify) {
            return localSessionId;
        }
        throw ElytronMessages.log.httpMechSsoInvalidLogoutMessage(localSessionId);
    }

    public static class DefaultSingleSignOnSessionEntry
    implements Serializable {
        private static final long serialVersionUID = 6051431359445846593L;
        private CachedIdentity cachedIdentity;
        private final Set<String> localSessions;

        public DefaultSingleSignOnSessionEntry(CachedIdentity cachedIdentity) {
            this.cachedIdentity = cachedIdentity;
            this.localSessions = new HashSet<String>();
        }

        CachedIdentity getCachedIdentity() {
            return this.cachedIdentity;
        }

        void setCachedIdentity(CachedIdentity cachedIdentity) {
            this.cachedIdentity = cachedIdentity;
        }

        Set<String> getLocalSessions() {
            return this.localSessions;
        }
    }

    private abstract class AbstractSingleSignOnSession
    implements SingleSignOnSession {
        private final HttpServerRequest request;

        AbstractSingleSignOnSession(HttpServerRequest request) {
            this.request = request;
        }

        @Override
        public Set<String> getLocalSessions() {
            DefaultSingleSignOnSessionEntry entry = this.getEntry();
            if (entry == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(entry.getLocalSessions());
        }

        @Override
        public String getLocalSession() {
            DefaultSingleSignOnSessionEntry entry = this.getEntry();
            if (entry == null) {
                return null;
            }
            HttpScope scope = this.request.getScope(Scope.SESSION);
            if (!scope.exists()) {
                return null;
            }
            return entry.getLocalSessions().stream().filter(localSession -> localSession.endsWith(scope.getID())).findFirst().orElse(null);
        }

        @Override
        public CachedIdentity get() {
            DefaultSingleSignOnSessionEntry entry = this.getEntry();
            if (entry == null) {
                return null;
            }
            return entry.getCachedIdentity();
        }

        @Override
        public CachedIdentity remove() {
            DefaultSingleSignOnSessionEntry entry = this.getEntry();
            if (entry == null) {
                return null;
            }
            DefaultSingleSignOnSessionEntry destroyed = (DefaultSingleSignOnSessionEntry)DefaultSingleSignOnSessionFactory.this.cache.remove(this.getId());
            this.invalidateLocalSession(this.request.getScope(Scope.SESSION));
            if (destroyed == null) {
                return null;
            }
            return destroyed.getCachedIdentity();
        }

        @Override
        public boolean logout() {
            String logoutMessage = this.request.getFirstParameterValue(DefaultSingleSignOnSessionFactory.LOGOUT_REQUEST_PARAMETER);
            if (logoutMessage == null) {
                return false;
            }
            ElytronMessages.log.debugf("Invalidating local session [%s] from SSO [%s]", this.getLocalSession(), this.getId());
            try {
                String localSessionId = DefaultSingleSignOnSessionFactory.this.verifyLogoutRequest(logoutMessage);
                HttpScope scope = this.request.getScope(Scope.SESSION, localSessionId);
                if (!scope.exists()) {
                    return false;
                }
                this.invalidateLocalSession(scope);
            }
            catch (Exception e) {
                ElytronMessages.log.errorHttpMechSsoFailedInvalidateLocalSession(e);
            }
            this.request.authenticationInProgress(response -> response.setStatusCode(200));
            return true;
        }

        void removeLocalSession(String localSessionId) {
            DefaultSingleSignOnSessionEntry entry = this.getEntry();
            if (entry != null) {
                ElytronMessages.log.debugf("Removing local session [%s] from SSO [%s]", localSessionId, this.getId());
                entry.getLocalSessions().remove(localSessionId);
                if (entry.getLocalSessions().isEmpty()) {
                    ElytronMessages.log.debugf("Destroying SSO [%s]. SSO is not associated with participants", this.getId());
                    this.remove();
                } else if (DefaultSingleSignOnSessionFactory.this.cache.containsKey(this.getId())) {
                    DefaultSingleSignOnSessionFactory.this.cache.put(this.getId(), entry);
                }
            }
        }

        void addLocalSessionIfNecessary(DefaultSingleSignOnSessionEntry entry) {
            if (this.getLocalSession() == null) {
                HttpScope scope = this.request.getScope(Scope.SESSION);
                if (!scope.exists()) {
                    scope.create();
                }
                String localSessionId = this.createLocalSessionId(scope.getID(), this.request);
                entry.getLocalSessions().add(localSessionId);
                String id = this.getId();
                scope.registerForNotification(notification -> {
                    HttpScope sessionScope = notification.getScope(Scope.SESSION);
                    boolean invalidating = sessionScope.getAttachment(SESSION_INVALIDATING_ATTRIBUTE) != null;
                    this.removeLocalSession(localSessionId);
                    if (notification.isOfType(HttpScopeNotification.SessionNotificationType.INVALIDATED) && !invalidating) {
                        DefaultSingleSignOnSessionFactory.this.logout(id);
                    }
                });
                DefaultSingleSignOnSessionFactory.this.cache.put(this.getId(), entry);
                ElytronMessages.log.debugf("Updating local sessions for SSO [%s]. New local session [%s]. Local sessions: [%s]", this.getId(), localSessionId, entry.getLocalSessions());
            }
        }

        void invalidateLocalSession(HttpScope scope) {
            if (!scope.exists()) {
                return;
            }
            scope.setAttachment(SESSION_INVALIDATING_ATTRIBUTE, true);
            scope.invalidate();
            ElytronMessages.log.debugf("Local session [%s] invalidated for SSO [%s]", scope.getID(), this.getId());
        }

        DefaultSingleSignOnSessionEntry getEntry() {
            String id = this.getId();
            if (id == null) {
                return null;
            }
            return (DefaultSingleSignOnSessionEntry)DefaultSingleSignOnSessionFactory.this.cache.get(id);
        }

        String createLocalSessionId(String localSessionId, HttpServerRequest request) {
            return this.createParticipantUrl(request) + ":" + localSessionId;
        }

        String createParticipantUrl(HttpServerRequest request) {
            String[] paths;
            String scheme = request.getRequestURI().getScheme();
            String host = request.getRequestURI().getHost();
            int port = request.getRequestURI().getPort();
            String path = request.getRequestURI().getPath();
            if (path == null) {
                path = "/";
            }
            if ((paths = path.split("/")).length > 1) {
                path = "/" + paths[1];
            }
            return scheme + "://" + host + ":" + port + path;
        }
    }
}

