/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.security.Principal;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.IdentityLocator;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.RealmAuthenticationEvent;
import org.wildfly.security.auth.server.event.RealmAuthorizationEvent;
import org.wildfly.security.auth.server.event.RealmEvent;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public final class AggregateSecurityRealm
implements SecurityRealm {
    private final SecurityRealm authenticationRealm;
    private final SecurityRealm authorizationRealm;

    public AggregateSecurityRealm(SecurityRealm authenticationRealm, SecurityRealm authorizationRealm) {
        this.authenticationRealm = authenticationRealm;
        this.authorizationRealm = authorizationRealm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RealmIdentity getRealmIdentity(IdentityLocator locator) throws RealmUnavailableException {
        boolean ok = false;
        RealmIdentity authenticationIdentity = this.authenticationRealm.getRealmIdentity(locator);
        try {
            RealmIdentity authorizationIdentity = this.authorizationRealm.getRealmIdentity(locator);
            try {
                Identity identity = new Identity(authenticationIdentity, authorizationIdentity);
                ok = true;
                Identity identity2 = identity;
                if (!ok) {
                    authorizationIdentity.dispose();
                }
                return identity2;
            }
            catch (Throwable throwable) {
                if (!ok) {
                    authorizationIdentity.dispose();
                }
                throw throwable;
            }
        }
        finally {
            if (!ok) {
                authenticationIdentity.dispose();
            }
        }
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        return this.authenticationRealm.getCredentialAcquireSupport(credentialType, algorithmName);
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return this.authenticationRealm.getEvidenceVerifySupport(evidenceType, algorithmName);
    }

    @Override
    public void handleRealmEvent(RealmEvent event) {
        if (event instanceof RealmAuthenticationEvent) {
            this.authenticationRealm.handleRealmEvent(event);
        } else if (event instanceof RealmAuthorizationEvent) {
            this.authorizationRealm.handleRealmEvent(event);
        } else {
            SecurityRealm.safeHandleRealmEvent(this.authenticationRealm, event);
            SecurityRealm.safeHandleRealmEvent(this.authorizationRealm, event);
        }
    }

    static final class Identity
    implements RealmIdentity {
        private final RealmIdentity authenticationIdentity;
        private final RealmIdentity authorizationIdentity;

        Identity(RealmIdentity authenticationIdentity, RealmIdentity authorizationIdentity) {
            this.authenticationIdentity = authenticationIdentity;
            this.authorizationIdentity = authorizationIdentity;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            return this.authenticationIdentity.getRealmIdentityPrincipal();
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredentialAcquireSupport(credentialType, algorithmName);
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.authenticationIdentity.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredential(credentialType, algorithmName);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredential(credentialType);
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            return this.authenticationIdentity.verifyEvidence(evidence);
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return this.authenticationIdentity.exists();
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            return this.authorizationIdentity.exists() ? this.authorizationIdentity.getAuthorizationIdentity() : AuthorizationIdentity.EMPTY;
        }

        @Override
        public void dispose() {
            this.authenticationIdentity.dispose();
            this.authorizationIdentity.dispose();
        }
    }
}

