/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.net.URI;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.ietf.jgss.GSSCredential;
import org.wildfly.common.Assert;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.client.ConfigurationKeyManager;
import org.wildfly.security.auth.client.FilterSaslMechanismAuthenticationConfiguration;
import org.wildfly.security.auth.client.ProvidersAuthenticationConfiguration;
import org.wildfly.security.auth.client.RewriteNameAuthenticationConfiguration;
import org.wildfly.security.auth.client.SSLContextAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetAllowAllSaslMechanisms;
import org.wildfly.security.auth.client.SetAnonymousAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetAuthorizationNameAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetChoiceAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCredentialsConfiguration;
import org.wildfly.security.auth.client.SetForwardAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetHostAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetKeyManagerCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetMechanismPropertiesConfiguration;
import org.wildfly.security.auth.client.SetNamePrincipalAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetParameterSpecAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetPortAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetProtocolAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetRealmAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetSaslClientFactoryAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetTrustManagerAuthenticationConfiguration;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.credential.GSSCredentialCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.credential.source.CallbackHandlerCredentialSource;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.source.CredentialStoreCredentialSource;
import org.wildfly.security.credential.source.KeyStoreCredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.sasl.util.FilterMechanismSaslClientFactory;
import org.wildfly.security.sasl.util.PropertiesSaslClientFactory;
import org.wildfly.security.sasl.util.ProtocolSaslClientFactory;
import org.wildfly.security.sasl.util.SecurityProviderSaslClientFactory;
import org.wildfly.security.sasl.util.ServerNameSaslClientFactory;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLUtils;
import org.wildfly.security.util.ServiceLoaderSupplier;

public abstract class AuthenticationConfiguration {
    public static final AuthenticationConfiguration EMPTY = new AuthenticationConfiguration(){

        @Override
        void handleCallback(Callback[] callbacks, int index) throws UnsupportedCallbackException {
            CallbackUtil.unsupported(callbacks[index]);
        }

        @Override
        void handleCallbacks(AuthenticationConfiguration config, Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            int length = callbacks.length;
            for (int i = 0; i < length; ++i) {
                config.handleCallback(callbacks, i);
            }
        }

        @Override
        void configureSaslProperties(Map<String, Object> properties) {
        }

        @Override
        boolean filterOneSaslMechanism(String mechanismName) {
            return false;
        }

        @Override
        String doRewriteUser(String original) {
            return original;
        }

        @Override
        AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
            return this;
        }

        @Override
        AuthenticationConfiguration without(Class<?> clazz) {
            return this;
        }

        @Override
        AuthenticationConfiguration without(Class<?> clazz1, Class<?> clazz2) {
            return this;
        }

        @Override
        String getHost() {
            return null;
        }

        @Override
        String getProtocol() {
            return null;
        }

        @Override
        int getPort() {
            return -1;
        }

        @Override
        Principal getPrincipal() {
            return AnonymousPrincipal.getInstance();
        }

        @Override
        String getAuthorizationName() {
            return null;
        }

        @Override
        SSLContext getSslContext() throws NoSuchAlgorithmException {
            return SSLContext.getDefault();
        }

        @Override
        void configureSslEngine(SSLEngine sslEngine) {
        }

        @Override
        void configureSslSocket(SSLSocket sslSocket) {
        }

        @Override
        ProtocolSelector getProtocolSelector() {
            return ProtocolSelector.defaultProtocols();
        }

        @Override
        CipherSuiteSelector getCipherSuiteSelector() {
            return CipherSuiteSelector.openSslDefault();
        }

        @Override
        SecurityFactory<X509TrustManager> getX509TrustManagerFactory() {
            return SSLUtils.getDefaultX509TrustManagerSecurityFactory();
        }

        @Override
        SecurityFactory<X509KeyManager> getX509KeyManagerFactory() {
            return null;
        }

        @Override
        void configureKeyManager(ConfigurationKeyManager.Builder builder) {
        }

        @Override
        Supplier<Provider[]> getProviderSupplier() {
            return Security::getProviders;
        }

        @Override
        SaslClientFactory getSaslClientFactory(Supplier<Provider[]> providers) {
            return new SecurityProviderSaslClientFactory(providers);
        }

        @Override
        boolean delegatesThrough(Class<?> clazz) {
            return false;
        }

        @Override
        CredentialSource getCredentialSource() {
            return CredentialSource.NONE;
        }

        @Override
        StringBuilder asString(StringBuilder sb) {
            return sb;
        }
    }.useAnonymous().useTrustManager(null);
    private final AuthenticationConfiguration parent;
    private final CallbackHandler callbackHandler = callbacks -> this.handleCallbacks(this, callbacks);
    private SaslClientFactory saslClientFactory = null;

    AuthenticationConfiguration() {
        this.parent = null;
    }

    AuthenticationConfiguration(AuthenticationConfiguration parent) {
        this(parent, false);
    }

    AuthenticationConfiguration(AuthenticationConfiguration parent, boolean allowMultiple) {
        this.parent = allowMultiple ? parent : parent.without(this.getClass());
    }

    Principal getPrincipal() {
        return this.parent.getPrincipal();
    }

    String getHost() {
        return this.parent.getHost();
    }

    String getProtocol() {
        return this.parent.getProtocol();
    }

    int getPort() {
        return this.parent.getPort();
    }

    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        this.parent.handleCallback(callbacks, index);
    }

    void handleCallbacks(AuthenticationConfiguration config, Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        this.parent.handleCallbacks(config, callbacks);
    }

    void configureSaslProperties(Map<String, Object> properties) {
        this.parent.configureSaslProperties(properties);
    }

    boolean filterOneSaslMechanism(String mechanismName) {
        return this.parent.filterOneSaslMechanism(mechanismName);
    }

    String doRewriteUser(String original) {
        return this.parent.doRewriteUser(original);
    }

    String getAuthorizationName() {
        return this.parent.getAuthorizationName();
    }

    SSLContext getSslContext() throws GeneralSecurityException {
        return this.parent.getSslContext();
    }

    void configureSslEngine(SSLEngine sslEngine) {
        this.parent.configureSslEngine(sslEngine);
    }

    void configureSslSocket(SSLSocket sslSocket) {
        this.parent.configureSslSocket(sslSocket);
    }

    ProtocolSelector getProtocolSelector() {
        return this.parent.getProtocolSelector();
    }

    CipherSuiteSelector getCipherSuiteSelector() {
        return this.parent.getCipherSuiteSelector();
    }

    Supplier<Provider[]> getProviderSupplier() {
        return this.parent.getProviderSupplier();
    }

    SaslClientFactory getSaslClientFactory(Supplier<Provider[]> providers) {
        return this.parent.getSaslClientFactory(providers);
    }

    SecurityFactory<X509TrustManager> getX509TrustManagerFactory() {
        return this.parent.getX509TrustManagerFactory();
    }

    SecurityFactory<X509KeyManager> getX509KeyManagerFactory() throws GeneralSecurityException {
        return this.parent.getX509KeyManagerFactory();
    }

    void configureKeyManager(ConfigurationKeyManager.Builder builder) throws GeneralSecurityException {
        this.parent.configureKeyManager(builder);
    }

    CredentialSource getCredentialSource() {
        return this.parent.getCredentialSource();
    }

    abstract AuthenticationConfiguration reparent(AuthenticationConfiguration var1);

    AuthenticationConfiguration without(Class<?> clazz) {
        if (clazz.isInstance(this)) {
            return this.parent;
        }
        AuthenticationConfiguration newParent = this.parent.without(clazz);
        if (this.parent == newParent) {
            return this;
        }
        return this.reparent(newParent);
    }

    AuthenticationConfiguration without(Class<?> clazz1, Class<?> clazz2) {
        if (clazz1.isInstance(this) && clazz2.isInstance(this)) {
            return this.parent;
        }
        if (clazz1.isInstance(this)) {
            return this.parent.without(clazz2);
        }
        if (clazz2.isInstance(this)) {
            return this.parent.without(clazz1);
        }
        AuthenticationConfiguration newParent = this.parent.without(clazz1, clazz2);
        if (this.parent == newParent) {
            return this;
        }
        return this.reparent(newParent);
    }

    boolean delegatesThrough(Class<?> clazz) {
        return clazz.isInstance(this) || this.parent.delegatesThrough(clazz);
    }

    public final AuthenticationConfiguration rewriteUser(NameRewriter rewriter) {
        if (rewriter == null) {
            return this;
        }
        return new RewriteNameAuthenticationConfiguration(this, rewriter);
    }

    public final AuthenticationConfiguration useAnonymous() {
        return new SetAnonymousAuthenticationConfiguration(this);
    }

    public final AuthenticationConfiguration usePrincipal(NamePrincipal principal) {
        return new SetNamePrincipalAuthenticationConfiguration(this, principal);
    }

    public final AuthenticationConfiguration useName(String name) {
        return this.usePrincipal(new NamePrincipal(name));
    }

    public final AuthenticationConfiguration useAuthorizationName(String name) {
        return new SetAuthorizationNameAuthenticationConfiguration(this, name);
    }

    public final AuthenticationConfiguration usePassword(Password password) {
        CredentialSource filtered = this.getCredentialSource().without(PasswordCredential.class);
        return password == null ? this.useCredentials(filtered) : this.useCredentials(filtered.with(IdentityCredentials.NONE.withCredential(new PasswordCredential(password))));
    }

    public final AuthenticationConfiguration usePassword(char[] password) {
        return this.usePassword(password == null ? null : ClearPassword.createRaw("clear", password));
    }

    public final AuthenticationConfiguration usePassword(String password) {
        return this.usePassword(password == null ? null : ClearPassword.createRaw("clear", password.toCharArray()));
    }

    public final AuthenticationConfiguration usePassword(Password password, Predicate<String> matchPredicate) {
        return this.usePassword(password);
    }

    public final AuthenticationConfiguration usePassword(char[] password, Predicate<String> matchPredicate) {
        return this.usePassword(password);
    }

    public final AuthenticationConfiguration usePassword(String password, Predicate<String> matchPredicate) {
        return this.usePassword(password);
    }

    public final AuthenticationConfiguration useCredentialCallbackHandler(CallbackHandler callbackHandler) {
        return callbackHandler == null ? this : this.useCredentials(new CallbackHandlerCredentialSource(callbackHandler).with(this.getCredentialSource()));
    }

    public final AuthenticationConfiguration useCallbackHandler(CallbackHandler callbackHandler) {
        return callbackHandler == null ? this : new SetCallbackHandlerAuthenticationConfiguration(this, callbackHandler);
    }

    public final AuthenticationConfiguration useGSSCredential(GSSCredential credential) {
        return credential == null ? this : this.useCredentials(this.getCredentialSource().with(IdentityCredentials.NONE.withCredential(new GSSCredentialCredential(credential))));
    }

    public final AuthenticationConfiguration useKeyStoreCredential(KeyStore.Entry keyStoreEntry) {
        return keyStoreEntry == null ? this : this.useCredentials(this.getCredentialSource().with(new KeyStoreCredentialSource(new FixedSecurityFactory<KeyStore.Entry>(keyStoreEntry))));
    }

    public final AuthenticationConfiguration useKeyStoreCredential(KeyStore keyStore, String alias) {
        return keyStore == null || alias == null ? this : this.useCredentials(this.getCredentialSource().with(new KeyStoreCredentialSource(keyStore, alias, null)));
    }

    public final AuthenticationConfiguration useKeyStoreCredential(KeyStore keyStore, String alias, KeyStore.ProtectionParameter protectionParameter) {
        return keyStore == null || alias == null ? this : this.useCredentials(this.getCredentialSource().with(new KeyStoreCredentialSource(keyStore, alias, protectionParameter)));
    }

    public final AuthenticationConfiguration useCertificateCredential(PrivateKey privateKey, X509Certificate ... certificateChain) {
        return certificateChain == null || certificateChain.length == 0 || privateKey == null ? this : this.useCertificateCredential(new X509CertificateChainPrivateCredential(privateKey, certificateChain));
    }

    public final AuthenticationConfiguration useCertificateCredential(X509CertificateChainPrivateCredential credential) {
        return credential == null ? this : this.useCredentials(this.getCredentialSource().with(IdentityCredentials.NONE.withCredential(credential)));
    }

    public AuthenticationConfiguration useCredentialStoreEntry(CredentialStore credentialStore, String alias) {
        Assert.checkNotNullParam((String)"credentialStore", (Object)credentialStore);
        Assert.checkNotNullParam((String)"alias", (Object)alias);
        CredentialStoreCredentialSource csCredentialSource = new CredentialStoreCredentialSource(credentialStore, alias);
        return this.useCredentials(this.getCredentialSource().with(csCredentialSource));
    }

    public final AuthenticationConfiguration useKeyManagerCredential(X509KeyManager keyManager) {
        return keyManager == null ? this.without(SetKeyManagerCredentialAuthenticationConfiguration.class) : new SetKeyManagerCredentialAuthenticationConfiguration(this, new FixedSecurityFactory<X509KeyManager>(keyManager));
    }

    public final AuthenticationConfiguration useCredentials(CredentialSource credentials) {
        return credentials == null ? this.without(SetCredentialsConfiguration.class) : new SetCredentialsConfiguration(this, credentials);
    }

    public final AuthenticationConfiguration useCredentials(CredentialSource credentials, Predicate<String> matchPredicate) {
        return this.useCredentials(credentials);
    }

    public final AuthenticationConfiguration useChoice(BiPredicate<Class<? extends ChoiceCallback>, String> matchPredicate, String choice) {
        return matchPredicate == null ? this : new SetChoiceAuthenticationConfiguration(this, matchPredicate, choice);
    }

    public final AuthenticationConfiguration useParameterSpec(AlgorithmParameterSpec parameterSpec) {
        return parameterSpec == null ? this : new SetParameterSpecAuthenticationConfiguration(this, parameterSpec);
    }

    public final AuthenticationConfiguration useTrustManager(X509TrustManager trustManager) {
        return trustManager == null ? new SetTrustManagerAuthenticationConfiguration(this, SSLUtils.getDefaultX509TrustManagerSecurityFactory()) : new SetTrustManagerAuthenticationConfiguration(this, new FixedSecurityFactory<X509TrustManager>(trustManager));
    }

    public final AuthenticationConfiguration useHost(String hostName) {
        if (hostName == null || hostName.isEmpty()) {
            return this.without(SetHostAuthenticationConfiguration.class);
        }
        return new SetHostAuthenticationConfiguration(this, hostName);
    }

    public final AuthenticationConfiguration useProtocol(String protocol) {
        if (protocol == null || protocol.isEmpty()) {
            return this.without(SetProtocolAuthenticationConfiguration.class);
        }
        return new SetProtocolAuthenticationConfiguration(this, protocol);
    }

    public final AuthenticationConfiguration usePort(int port) {
        if (port < 1 || port > 65535) {
            throw ElytronMessages.log.invalidPortNumber(port);
        }
        return new SetPortAuthenticationConfiguration(this, port);
    }

    public final AuthenticationConfiguration useForwardedIdentity(SecurityDomain securityDomain) {
        Assert.checkNotNullParam((String)"securityDomain", (Object)securityDomain);
        AccessControlContext context = AccessController.getContext();
        return new SetForwardAuthenticationConfiguration(this, securityDomain, context);
    }

    public final AuthenticationConfiguration useProviders(Supplier<Provider[]> providerSupplier) {
        return providerSupplier == null ? this.useDefaultProviders() : new ProvidersAuthenticationConfiguration(this, providerSupplier);
    }

    public final AuthenticationConfiguration useDefaultProviders() {
        return this.without(ProvidersAuthenticationConfiguration.class);
    }

    public final AuthenticationConfiguration useProvidersFromClassLoader(ClassLoader classLoader) {
        return this.useProviders(new ServiceLoaderSupplier<Provider>(Provider.class, classLoader));
    }

    public final AuthenticationConfiguration useSaslClientFactory(SaslClientFactory saslClientFactory) {
        return this.useSaslClientFactory(() -> saslClientFactory);
    }

    public final AuthenticationConfiguration useSaslClientFactory(Supplier<SaslClientFactory> saslClientFactory) {
        return new SetSaslClientFactoryAuthenticationConfiguration(this, saslClientFactory);
    }

    public final AuthenticationConfiguration useSaslClientFactoryFromProviders() {
        return this.without(SetSaslClientFactoryAuthenticationConfiguration.class);
    }

    public final AuthenticationConfiguration useMechanismProperties(Map<String, String> mechanismProperties) {
        return mechanismProperties == null || mechanismProperties.isEmpty() ? this : new SetMechanismPropertiesConfiguration(this, mechanismProperties);
    }

    public final AuthenticationConfiguration allowAllSaslMechanisms() {
        return new SetAllowAllSaslMechanisms(this);
    }

    public final AuthenticationConfiguration allowSaslMechanisms(String ... names) {
        return names == null || names.length == 0 ? new FilterSaslMechanismAuthenticationConfiguration(this, true, Collections.emptySet()) : new FilterSaslMechanismAuthenticationConfiguration(this, true, new HashSet<String>(Arrays.asList(names)));
    }

    public final AuthenticationConfiguration forbidSaslMechanisms(String ... names) {
        return names == null || names.length == 0 ? this : new FilterSaslMechanismAuthenticationConfiguration(this, false, new HashSet<String>(Arrays.asList(names)));
    }

    public final AuthenticationConfiguration useSslContext(SSLContext sslContext) {
        return sslContext == null ? this.without(SSLContextAuthenticationConfiguration.class) : new SSLContextAuthenticationConfiguration(this, sslContext);
    }

    public final AuthenticationConfiguration useSslContext(SecurityFactory<SSLContext> sslContextFactory) {
        return sslContextFactory == null ? this.without(SSLContextAuthenticationConfiguration.class) : new SSLContextAuthenticationConfiguration(this, sslContextFactory);
    }

    public final AuthenticationConfiguration useRealm(String realm) {
        return new SetRealmAuthenticationConfiguration(this, realm);
    }

    final CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SaslClientFactory getSaslClientFactory() {
        if (this.saslClientFactory == null) {
            AuthenticationConfiguration authenticationConfiguration = this;
            synchronized (authenticationConfiguration) {
                if (this.saslClientFactory == null) {
                    this.saslClientFactory = this.getSaslClientFactory(this.getProviderSupplier());
                }
            }
        }
        return this.saslClientFactory;
    }

    final SaslClient createSaslClient(URI uri, Collection<String> serverMechanisms, UnaryOperator<SaslClientFactory> factoryOperator) throws SaslException {
        String protocol;
        String host;
        SaslClientFactory saslClientFactory = (SaslClientFactory)factoryOperator.apply(this.getSaslClientFactory());
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.configureSaslProperties(properties);
        if (!properties.isEmpty()) {
            saslClientFactory = new PropertiesSaslClientFactory(saslClientFactory, properties);
        }
        if ((host = this.getHost()) != null) {
            saslClientFactory = new ServerNameSaslClientFactory(saslClientFactory, host);
        }
        if ((protocol = this.getProtocol()) != null) {
            saslClientFactory = new ProtocolSaslClientFactory(saslClientFactory, protocol);
        }
        saslClientFactory = new FilterMechanismSaslClientFactory(saslClientFactory, this::filterOneSaslMechanism);
        return saslClientFactory.createSaslClient(serverMechanisms.toArray(new String[serverMechanisms.size()]), this.getAuthorizationName(), uri.getScheme(), uri.getHost(), Collections.emptyMap(), this.getCallbackHandler());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.asString(sb);
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    abstract StringBuilder asString(StringBuilder var1);

    final StringBuilder parentAsString(StringBuilder sb) {
        return this.parent.asString(sb);
    }

    static interface CredentialSetting {
    }

    static interface UserSetting {
    }
}

