/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JaasSecurityRealm
implements SecurityRealm {
    private final String loginConfiguration;
    private final CallbackHandler handler;

    public JaasSecurityRealm(String loginConfiguration) {
        this(loginConfiguration, null);
    }

    public JaasSecurityRealm(String loginConfiguration, CallbackHandler handler) {
        this.loginConfiguration = loginConfiguration;
        this.handler = handler;
    }

    @Override
    public RealmIdentity getRealmIdentity(Principal principal) {
        return principal instanceof NamePrincipal ? new JaasRealmIdentity(principal) : RealmIdentity.NON_EXISTENT;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return SupportLevel.UNSUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidenceType", evidenceType);
        return PasswordGuessEvidence.class.isAssignableFrom(evidenceType) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    private LoginContext createLoginContext(String loginConfig, Subject subject, CallbackHandler handler) throws RealmUnavailableException {
        if (WildFlySecurityManager.isChecking()) {
            try {
                return AccessController.doPrivileged(() -> new LoginContext(loginConfig, subject, handler));
            }
            catch (PrivilegedActionException pae) {
                throw ElytronMessages.log.failedToCreateLoginContext(pae.getCause());
            }
        }
        try {
            return new LoginContext(loginConfig, subject, handler);
        }
        catch (LoginException le) {
            throw ElytronMessages.log.failedToCreateLoginContext(le);
        }
    }

    private CallbackHandler createCallbackHandler(Principal principal, PasswordGuessEvidence evidence) throws RealmUnavailableException {
        if (this.handler == null) {
            return new DefaultCallbackHandler(principal, evidence);
        }
        try {
            CallbackHandler callbackHandler = (CallbackHandler)this.handler.getClass().newInstance();
            Method setSecurityInfo = this.handler.getClass().getMethod("setSecurityInfo", Principal.class, Object.class);
            setSecurityInfo.invoke((Object)callbackHandler, principal, evidence);
            return callbackHandler;
        }
        catch (Exception e) {
            throw ElytronMessages.log.failedToInstantiateCustomHandler(e);
        }
    }

    private class JaasAuthorizationIdentity
    implements AuthorizationIdentity {
        private static final String CALLER_PRINCIPAL_GROUP = "CallerPrincipal";
        private final Principal principal;
        private Principal callerPrincipal;
        private final Subject subject;

        private JaasAuthorizationIdentity(Principal principal, Subject subject) {
            this.principal = principal;
            this.subject = subject;
            this.callerPrincipal = this.getCallerPrincipal(subject);
        }

        private Principal getCallerPrincipal(Subject subject) {
            Set<Principal> principals;
            Principal callerPrincipal = null;
            if (subject != null && (principals = subject.getPrincipals()) != null && !principals.isEmpty()) {
                for (Principal principal : principals) {
                    Enumeration enumeration;
                    if (!(principal instanceof Group) || !principal.getName().equals(CALLER_PRINCIPAL_GROUP) || !(enumeration = ((Group)principal).members()).hasMoreElements()) continue;
                    callerPrincipal = (Principal)enumeration.nextElement();
                    break;
                }
            }
            return callerPrincipal;
        }
    }

    private class DefaultCallbackHandler
    implements CallbackHandler {
        private final Principal principal;
        private final PasswordGuessEvidence evidence;

        private DefaultCallbackHandler(Principal principal, PasswordGuessEvidence evidence) {
            this.principal = principal;
            this.evidence = evidence;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            Assert.checkNotNullParam((String)"callbacks", (Object)callbacks);
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callback;
                    if (this.principal == null) continue;
                    nameCallback.setName(this.principal.getName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.evidence.getGuess());
                    continue;
                }
                CallbackUtil.unsupported(callback);
            }
        }
    }

    private class JaasRealmIdentity
    implements RealmIdentity {
        private final Principal principal;
        private Subject subject;

        private JaasRealmIdentity(Principal principal) {
            this.principal = principal;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            return this.principal;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return JaasSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.getCredential(credentialType, null);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return null;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidenceType", evidenceType);
            return JaasSecurityRealm.this.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidence", (Object)evidence);
            if (evidence instanceof PasswordGuessEvidence) {
                boolean successfulLogin;
                this.subject = null;
                CallbackHandler callbackHandler = JaasSecurityRealm.this.createCallbackHandler(this.principal, (PasswordGuessEvidence)evidence);
                Subject subject = new Subject();
                LoginContext context = JaasSecurityRealm.this.createLoginContext(JaasSecurityRealm.this.loginConfiguration, subject, callbackHandler);
                try {
                    context.login();
                    successfulLogin = true;
                    this.subject = subject;
                }
                catch (LoginException le) {
                    ElytronMessages.log.debugJAASAuthenticationFailure(this.principal, le);
                    successfulLogin = false;
                }
                return successfulLogin;
            }
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return true;
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            return new JaasAuthorizationIdentity(this.principal, this.subject);
        }
    }
}

