/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential;

import java.security.spec.AlgorithmParameterSpec;
import java.util.function.Function;
import org.wildfly.security.credential.Credential;

public interface AlgorithmCredential
extends Credential {
    public String getAlgorithm();

    @Override
    public AlgorithmCredential clone();

    @Override
    default public <C extends Credential, R> R castAndApply(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Function<C, R> function) {
        return !(!credentialType.isInstance(this) || algorithmName != null && !algorithmName.equals(this.getAlgorithm()) || parameterSpec != null && !this.impliesParameters(parameterSpec)) ? (R)function.apply(credentialType.cast(this)) : null;
    }

    @Override
    default public <C extends Credential, R> R castAndApply(Class<C> credentialType, String algorithmName, Function<C, R> function) {
        return credentialType.isInstance(this) && (algorithmName == null || algorithmName.equals(this.getAlgorithm())) ? (R)function.apply(credentialType.cast(this)) : null;
    }

    @Override
    default public boolean matches(Credential other) {
        return other instanceof AlgorithmCredential && this.matches((AlgorithmCredential)other);
    }

    @Override
    default public boolean matches(AlgorithmCredential other) {
        return other != null && other.getClass() == this.getClass() && this.getAlgorithm().equals(other.getAlgorithm()) && this.impliesSameParameters(other);
    }
}

