/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.cache;

import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.cache.RealmIdentityCache;

public final class LRURealmIdentityCache
implements RealmIdentityCache {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final Map<Principal, RealmIdentity> identityCache;
    private final Map<Principal, Set<Principal>> domainPrincipalMap;
    private final AtomicBoolean writing = new AtomicBoolean(false);

    public LRURealmIdentityCache(final int maxEntries) {
        Assert.checkMinimumParameter((String)"maxEntries", (int)1, (int)maxEntries);
        this.identityCache = new LinkedHashMap<Principal, RealmIdentity>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return LRURealmIdentityCache.this.identityCache.size() > maxEntries;
            }
        };
        this.domainPrincipalMap = new HashMap<Principal, Set<Principal>>(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Principal key, RealmIdentity newValue) {
        try {
            if (this.parkForWriteAndCheckInterrupt()) {
                return;
            }
            RealmIdentity realmIdentity = this.identityCache.computeIfAbsent(key, (? super K principal) -> {
                this.domainPrincipalMap.computeIfAbsent(newValue.getRealmIdentityPrincipal(), (? super K principal1) -> {
                    HashSet<Principal> principals = new HashSet<Principal>();
                    principals.add(key);
                    return principals;
                });
                return newValue;
            });
            if (realmIdentity != null) {
                this.domainPrincipalMap.get(realmIdentity.getRealmIdentityPrincipal()).add(key);
            }
        }
        finally {
            this.writing.lazySet(false);
        }
    }

    @Override
    public RealmIdentity get(Principal key) {
        if (this.parkForReadAndCheckInterrupt()) {
            return null;
        }
        RealmIdentity cached = this.identityCache.get(key);
        if (cached != null) {
            return cached;
        }
        Set<Principal> domainPrincipal = this.domainPrincipalMap.get(key);
        if (domainPrincipal != null) {
            return this.identityCache.get(domainPrincipal.iterator().next());
        }
        return null;
    }

    @Override
    public void remove(Principal key) {
        try {
            if (this.parkForWriteAndCheckInterrupt()) {
                return;
            }
            if (this.identityCache.containsKey(key)) {
                this.domainPrincipalMap.remove(this.identityCache.remove(key).getRealmIdentityPrincipal()).forEach(this.identityCache::remove);
            } else if (this.domainPrincipalMap.containsKey(key)) {
                this.domainPrincipalMap.remove(key).forEach(this.identityCache::remove);
            }
        }
        finally {
            this.writing.lazySet(false);
        }
    }

    @Override
    public void clear() {
        try {
            this.parkForWriteAndCheckInterrupt();
            this.identityCache.clear();
            this.domainPrincipalMap.clear();
        }
        finally {
            this.writing.lazySet(false);
        }
    }

    private boolean parkForWriteAndCheckInterrupt() {
        while (!this.writing.compareAndSet(false, true)) {
            LockSupport.parkNanos(1L);
            if (!Thread.interrupted()) continue;
            return true;
        }
        return false;
    }

    private boolean parkForReadAndCheckInterrupt() {
        while (this.writing.get()) {
            LockSupport.parkNanos(1L);
            if (!Thread.interrupted()) continue;
            return true;
        }
        return false;
    }
}

