/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz;

import java.util.HashSet;
import java.util.Set;
import org.wildfly.common.Assert;
import org.wildfly.security.authz.DifferenceSet;
import org.wildfly.security.authz.DisjunctionSet;
import org.wildfly.security.authz.IntersectionSet;
import org.wildfly.security.authz.UnionSet;

public interface RoleMapper {
    public static final RoleMapper IDENTITY_ROLE_MAPPER = rolesToMap -> rolesToMap;

    public Set<String> mapRoles(Set<String> var1);

    default public RoleMapper and(RoleMapper other) {
        Assert.checkNotNullParam((String)"other", (Object)other);
        RoleMapper left = this;
        return rolesToMap -> new IntersectionSet(left.mapRoles(rolesToMap), other.mapRoles(rolesToMap));
    }

    default public RoleMapper or(RoleMapper other) {
        Assert.checkNotNullParam((String)"other", (Object)other);
        RoleMapper left = this;
        return rolesToMap -> new UnionSet(left.mapRoles(rolesToMap), other.mapRoles(rolesToMap));
    }

    default public RoleMapper xor(RoleMapper other) {
        Assert.checkNotNullParam((String)"other", (Object)other);
        RoleMapper left = this;
        return rolesToMap -> new DisjunctionSet(left.mapRoles(rolesToMap), other.mapRoles(rolesToMap));
    }

    default public RoleMapper minus(RoleMapper other) {
        Assert.checkNotNullParam((String)"other", (Object)other);
        RoleMapper left = this;
        return rolesToMap -> new DifferenceSet(left.mapRoles(rolesToMap), other.mapRoles(rolesToMap));
    }

    default public RoleMapper caching() {
        return new RoleMapper(){

            @Override
            public Set<String> mapRoles(Set<String> rolesToMap) {
                if (rolesToMap instanceof HashSet) {
                    return rolesToMap;
                }
                return new HashSet<String>(RoleMapper.this.mapRoles(rolesToMap));
            }

            @Override
            public RoleMapper caching() {
                return this;
            }
        };
    }

    public static RoleMapper aggregate(RoleMapper mapper1, RoleMapper mapper2) {
        Assert.checkNotNullParam((String)"mapper1", (Object)mapper1);
        Assert.checkNotNullParam((String)"mapper2", (Object)mapper2);
        return rolesToMap -> mapper2.mapRoles(mapper1.mapRoles(rolesToMap));
    }

    public static RoleMapper aggregate(RoleMapper ... mappers) {
        Assert.checkNotNullParam((String)"mappers", (Object)mappers);
        RoleMapper[] clone = (RoleMapper[])mappers.clone();
        for (int i = 0; i < clone.length; ++i) {
            Assert.checkNotNullArrayParam((String)"mappers", (int)i, (Object)clone[i]);
        }
        return rolesToMap -> {
            for (RoleMapper r : clone) {
                rolesToMap = r.mapRoles(rolesToMap);
            }
            return rolesToMap;
        };
    }

    public static RoleMapper constant(Set<String> roles) {
        Assert.checkNotNullParam((String)"roles", roles);
        return r -> roles;
    }
}

