/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.principal.NamePrincipal;

class SetNamePrincipalAuthenticationConfiguration
extends AuthenticationConfiguration
implements AuthenticationConfiguration.UserSetting {
    private final NamePrincipal principal;

    SetNamePrincipalAuthenticationConfiguration(AuthenticationConfiguration parent, NamePrincipal principal) {
        super(parent.without(AuthenticationConfiguration.UserSetting.class));
        this.principal = principal;
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws UnsupportedCallbackException, IOException {
        Callback callback = callbacks[index];
        if (callback instanceof NameCallback) {
            ((NameCallback)callback).setName(this.doRewriteUser(this.principal.getName()));
        } else {
            super.handleCallback(callbacks, index);
        }
    }

    @Override
    Principal getPrincipal() {
        return this.principal;
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetNamePrincipalAuthenticationConfiguration(newParent, this.principal);
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        return this.parentAsString(sb).append("NamePrincipal=").append(this.principal != null ? this.principal.toString() : "").append(',');
    }
}

