/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.AccessController;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.principal.RealmNestedPrincipal;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmInfo;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.PermissionMapper;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.permission.ElytronPermission;
import org.wildfly.security.permission.PermissionVerifier;

public final class SecurityDomain {
    static final ElytronPermission CREATE_SECURITY_DOMAIN = ElytronPermission.forName("createSecurityDomain");
    static final ElytronPermission CREATE_AUTH_CONTEXT = ElytronPermission.forName("createServerAuthenticationContext");
    static final ElytronPermission GET_IDENTITY = ElytronPermission.forName("getIdentity");
    static final ElytronPermission GET_IDENTITY_FOR_UPDATE = ElytronPermission.forName("getIdentityForUpdate");
    private final Map<String, RealmInfo> realmMap;
    private final String defaultRealmName;
    private final Function<Principal, Principal> preRealmPrincipalRewriter;
    private final RealmMapper realmMapper;
    private final Function<Principal, Principal> postRealmPrincipalRewriter;
    private final ThreadLocal<SecurityIdentity> currentSecurityIdentity;
    private final RoleMapper roleMapper;
    private final SecurityIdentity anonymousIdentity;
    private final PermissionMapper permissionMapper;
    private final Map<String, RoleMapper> categoryRoleMappers;
    private final UnaryOperator<SecurityIdentity> securityIdentityTransformer;
    private final Predicate<SecurityDomain> trustedSecurityDomain;

    SecurityDomain(Builder builder, LinkedHashMap<String, RealmInfo> realmMap) {
        Map<String, RoleMapper> copiedRoleMappers;
        this.realmMap = realmMap;
        this.defaultRealmName = builder.defaultRealmName;
        this.preRealmPrincipalRewriter = builder.principalDecoder.andThen(builder.preRealmRewriter);
        this.realmMapper = builder.realmMapper;
        this.roleMapper = builder.roleMapper;
        this.permissionMapper = builder.permissionMapper;
        this.postRealmPrincipalRewriter = builder.postRealmRewriter;
        this.securityIdentityTransformer = builder.securityIdentityTransformer;
        this.trustedSecurityDomain = builder.trustedSecurityDomain;
        Map originalRoleMappers = builder.categoryRoleMappers;
        if (originalRoleMappers.isEmpty()) {
            copiedRoleMappers = Collections.emptyMap();
        } else if (originalRoleMappers.size() == 1) {
            Map.Entry entry = originalRoleMappers.entrySet().iterator().next();
            copiedRoleMappers = Collections.singletonMap(entry.getKey(), entry.getValue());
        } else {
            copiedRoleMappers = new LinkedHashMap(originalRoleMappers);
        }
        this.categoryRoleMappers = copiedRoleMappers;
        RealmInfo realmInfo = new RealmInfo();
        this.anonymousIdentity = (SecurityIdentity)Assert.assertNotNull(this.securityIdentityTransformer.apply(new SecurityIdentity(this, AnonymousPrincipal.getInstance(), realmInfo, AuthorizationIdentity.EMPTY, copiedRoleMappers, IdentityCredentials.NONE, IdentityCredentials.NONE)));
        this.currentSecurityIdentity = ThreadLocal.withInitial(() -> this.anonymousIdentity);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ServerAuthenticationContext createNewAuthenticationContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_AUTH_CONTEXT);
        }
        return new ServerAuthenticationContext(this, MechanismConfigurationSelector.constantSelector(MechanismConfiguration.EMPTY));
    }

    public ServerAuthenticationContext createNewAuthenticationContext(MechanismConfigurationSelector mechanismConfigurationSelector) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_AUTH_CONTEXT);
        }
        return new ServerAuthenticationContext(this, mechanismConfigurationSelector);
    }

    ServerAuthenticationContext createNewAuthenticationContext(SecurityIdentity capturedIdentity, MechanismConfigurationSelector mechanismConfigurationSelector) {
        assert (capturedIdentity.getSecurityDomain() == this);
        return new ServerAuthenticationContext(capturedIdentity, mechanismConfigurationSelector);
    }

    public RealmIdentity getIdentity(String name) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.getIdentity(new NamePrincipal(name));
    }

    public RealmIdentity getIdentity(Principal principal) throws RealmUnavailableException, IllegalArgumentException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_IDENTITY);
        }
        return this.getIdentityPrivileged(principal, SecurityRealm.class, SecurityRealm::getRealmIdentity, () -> RealmIdentity.NON_EXISTENT, () -> RealmIdentity.ANONYMOUS);
    }

    public ModifiableRealmIdentity getIdentityForUpdate(Principal principal) throws RealmUnavailableException, IllegalArgumentException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_IDENTITY_FOR_UPDATE);
        }
        return this.getIdentityPrivileged(principal, ModifiableSecurityRealm.class, ModifiableSecurityRealm::getRealmIdentityForUpdate, () -> ModifiableRealmIdentity.NON_EXISTENT, () -> ModifiableRealmIdentity.NON_EXISTENT);
    }

    public ExceptionFunction<Principal, RealmIdentity, RealmUnavailableException> getIdentityLookupFunction() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_IDENTITY);
        }
        return p -> this.getIdentityPrivileged((Principal)p, (Class)SecurityRealm.class, SecurityRealm::getRealmIdentity, () -> RealmIdentity.NON_EXISTENT, () -> RealmIdentity.ANONYMOUS);
    }

    public ExceptionFunction<Principal, ModifiableRealmIdentity, RealmUnavailableException> getIdentityLookupForUpdateFunction() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_IDENTITY_FOR_UPDATE);
        }
        return p -> this.getIdentityPrivileged((Principal)p, (Class)ModifiableSecurityRealm.class, ModifiableSecurityRealm::getRealmIdentityForUpdate, () -> ModifiableRealmIdentity.NON_EXISTENT, () -> ModifiableRealmIdentity.NON_EXISTENT);
    }

    <I, R extends SecurityRealm> I getIdentityPrivileged(Principal principal, Class<R> realmType, ExceptionBiFunction<R, Principal, I, RealmUnavailableException> fn, Supplier<I> nonExistent, Supplier<I> anonymous) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"principal", (Object)principal);
        if (principal instanceof AnonymousPrincipal) {
            return anonymous.get();
        }
        if (principal instanceof RealmNestedPrincipal) {
            RealmNestedPrincipal realmNestedPrincipal = (RealmNestedPrincipal)principal;
            SecurityRealm securityRealm = this.getRealmInfo(realmNestedPrincipal.getRealmName()).getSecurityRealm();
            if (realmType.isInstance(securityRealm)) {
                return (I)fn.apply(realmType.cast(securityRealm), (Object)realmNestedPrincipal.getNestedPrincipal());
            }
            return nonExistent.get();
        }
        Principal preRealmPrincipal = this.preRealmPrincipalRewriter.apply(principal);
        if (preRealmPrincipal == null) {
            throw ElytronMessages.log.invalidName();
        }
        String realmName = this.mapRealmName(preRealmPrincipal, null);
        RealmInfo realmInfo = this.getRealmInfo(realmName);
        SecurityRealm securityRealm = realmInfo.getSecurityRealm();
        assert (securityRealm != null);
        Principal postRealmPrincipal = this.postRealmPrincipalRewriter.apply(preRealmPrincipal);
        if (postRealmPrincipal == null) {
            throw ElytronMessages.log.invalidName();
        }
        Principal realmRewrittenPrincipal = realmInfo.getPrincipalRewriter().apply(postRealmPrincipal);
        if (realmRewrittenPrincipal == null) {
            throw ElytronMessages.log.invalidName();
        }
        ElytronMessages.log.tracef("Principal mapping: [%s], pre-realm rewritten: [%s], realm name: [%s], post realm rewritten: [%s], realm rewritten: [%s]", new Object[]{principal, preRealmPrincipal, realmName, postRealmPrincipal, realmRewrittenPrincipal});
        if (realmType.isInstance(securityRealm)) {
            return (I)fn.apply(realmType.cast(securityRealm), (Object)realmRewrittenPrincipal);
        }
        return nonExistent.get();
    }

    SecurityRealm getRealm(String realmName) {
        return this.getRealmInfo(realmName).getSecurityRealm();
    }

    RealmInfo getRealmInfo(String realmName) {
        RealmInfo realmInfo = this.realmMap.get(realmName);
        if (realmInfo == null) {
            realmInfo = this.realmMap.get(this.defaultRealmName);
        }
        return realmInfo;
    }

    Collection<RealmInfo> getRealmInfos() {
        return this.realmMap.values();
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) {
        return this.getSupportLevel(r -> {
            try {
                return r.getCredentialAcquireSupport(credentialType, algorithmName);
            }
            catch (RealmUnavailableException e) {
                return null;
            }
        });
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType) {
        return this.getCredentialAcquireSupport(credentialType, null);
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) {
        return this.getSupportLevel(r -> {
            try {
                return r.getEvidenceVerifySupport(evidenceType, algorithmName);
            }
            catch (RealmUnavailableException e) {
                return null;
            }
        });
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType) {
        return this.getEvidenceVerifySupport(evidenceType, null);
    }

    private SupportLevel getSupportLevel(Function<SecurityRealm, SupportLevel> getSupportLevel) {
        SupportLevel max = null;
        SupportLevel min = null;
        for (RealmInfo realmInfo : this.realmMap.values()) {
            SecurityRealm realm = realmInfo.getSecurityRealm();
            SupportLevel support = getSupportLevel.apply(realm);
            if (support == null) continue;
            if (min == null || max == null) {
                min = max = support;
                continue;
            }
            if (support.compareTo(min) < 0) {
                min = support;
            }
            if (support.compareTo(max) <= 0) continue;
            max = support;
        }
        if (min == null || max == null) {
            return SupportLevel.UNSUPPORTED;
        }
        return this.minMax(min, max);
    }

    private SupportLevel minMax(SupportLevel min, SupportLevel max) {
        if (min == max) {
            return min;
        }
        if (max == SupportLevel.UNSUPPORTED) {
            return SupportLevel.UNSUPPORTED;
        }
        if (min == SupportLevel.SUPPORTED) {
            return SupportLevel.SUPPORTED;
        }
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    public SecurityIdentity getCurrentSecurityIdentity() {
        SecurityIdentity identity = this.currentSecurityIdentity.get();
        return identity == null ? this.anonymousIdentity : identity;
    }

    public SecurityIdentity getAnonymousSecurityIdentity() {
        return this.anonymousIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SecurityIdentity getAndSetCurrentSecurityIdentity(SecurityIdentity newIdentity) {
        try {
            SecurityIdentity oldIdentity = this.currentSecurityIdentity.get();
            SecurityIdentity securityIdentity = oldIdentity == null ? this.anonymousIdentity : oldIdentity;
            return securityIdentity;
        }
        finally {
            if (newIdentity == this.anonymousIdentity) {
                this.currentSecurityIdentity.remove();
            } else {
                this.currentSecurityIdentity.set(newIdentity);
            }
        }
    }

    void setCurrentSecurityIdentity(SecurityIdentity newIdentity) {
        if (newIdentity == this.anonymousIdentity) {
            this.currentSecurityIdentity.remove();
        } else {
            this.currentSecurityIdentity.set(newIdentity);
        }
    }

    Roles mapRoles(SecurityIdentity securityIdentity) {
        Assert.checkNotNullParam((String)"securityIdentity", (Object)securityIdentity);
        AuthorizationIdentity identity = securityIdentity.getAuthorizationIdentity();
        RealmInfo realmInfo = securityIdentity.getRealmInfo();
        Roles decodedRoles = realmInfo.getRoleDecoder().decodeRoles(identity);
        Roles realmMappedRoles = realmInfo.getRoleMapper().mapRoles(decodedRoles);
        Roles domainMappedRoles = this.roleMapper.mapRoles(realmMappedRoles);
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("Role mapping: principal [%s] -> decoded roles [%s] -> realm mapped roles [%s] -> domain mapped roles [%s]", new Object[]{securityIdentity.getPrincipal(), String.join((CharSequence)", ", decodedRoles), String.join((CharSequence)", ", realmMappedRoles), String.join((CharSequence)", ", domainMappedRoles)});
        }
        return domainMappedRoles;
    }

    PermissionVerifier mapPermissions(SecurityIdentity securityIdentity) {
        Assert.checkNotNullParam((String)"securityIdentity", (Object)securityIdentity);
        Roles roles = securityIdentity.getRoles();
        PermissionVerifier verifier = this.permissionMapper.mapPermissions(securityIdentity, roles);
        if (ElytronMessages.log.isTraceEnabled()) {
            return permission -> {
                boolean decision = verifier.implies(permission);
                ElytronMessages.log.tracef("Permission mapping: identity [%s] with roles [%s] implies %s = %b", new Object[]{securityIdentity.getPrincipal(), String.join((CharSequence)", ", roles), permission, decision});
                return decision;
            };
        }
        return verifier;
    }

    Function<Principal, Principal> getPreRealmRewriter() {
        return this.preRealmPrincipalRewriter;
    }

    String mapRealmName(Principal principal, Evidence evidence) {
        String realm = this.realmMapper.getRealmMapping(principal, evidence);
        return realm != null ? realm : this.defaultRealmName;
    }

    String getDefaultRealmName() {
        return this.defaultRealmName;
    }

    RealmMapper getRealmMapper() {
        return this.realmMapper;
    }

    Function<Principal, Principal> getPostRealmRewriter() {
        return this.postRealmPrincipalRewriter;
    }

    RoleMapper getRoleMapper() {
        return this.roleMapper;
    }

    Map<String, RoleMapper> getCategoryRoleMappers() {
        return this.categoryRoleMappers;
    }

    SecurityIdentity transform(SecurityIdentity securityIdentity) {
        Assert.checkNotNullParam((String)"securityIdentity", (Object)securityIdentity);
        return (SecurityIdentity)Assert.assertNotNull(this.securityIdentityTransformer.apply(securityIdentity));
    }

    boolean trustsDomain(SecurityDomain domain) {
        Assert.checkNotNullParam((String)"domain", (Object)domain);
        return this == domain || this.trustedSecurityDomain.test(domain);
    }

    public static ScheduledExecutorService getScheduledExecutorService() {
        return ScheduledExecutorServiceProvider.INSTANCE;
    }

    private static class ScheduledExecutorServiceProvider {
        private static final ThreadFactory threadFactory = (ThreadFactory)AccessController.doPrivileged(() -> new JBossThreadFactory(new ThreadGroup("SecurityDomain ThreadGroup"), Boolean.FALSE, null, "%G - %t", null, null));
        private static final ScheduledThreadPoolExecutor INSTANCE = new ScheduledThreadPoolExecutor(1, threadFactory);

        private ScheduledExecutorServiceProvider() {
        }

        static {
            INSTANCE.setRemoveOnCancelPolicy(true);
            INSTANCE.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        }
    }

    public static class RealmBuilder {
        private final Builder parent;
        private final String name;
        private final SecurityRealm realm;
        private RoleMapper roleMapper = RoleMapper.IDENTITY_ROLE_MAPPER;
        private Function<Principal, Principal> principalRewriter = Function.identity();
        private RoleDecoder roleDecoder = RoleDecoder.DEFAULT;
        private boolean built = false;

        RealmBuilder(Builder parent, String name, SecurityRealm realm) {
            this.parent = parent;
            this.name = name;
            this.realm = realm;
        }

        public String getName() {
            return this.name;
        }

        public SecurityRealm getRealm() {
            return this.realm;
        }

        public RoleMapper getRoleMapper() {
            return this.roleMapper;
        }

        public RealmBuilder setRoleMapper(RoleMapper roleMapper) {
            this.assertNotBuilt();
            Assert.checkNotNullParam((String)"roleMapper", (Object)roleMapper);
            this.roleMapper = roleMapper;
            return this;
        }

        public Function<Principal, Principal> getPrincipalRewriter() {
            return this.principalRewriter;
        }

        public RealmBuilder setPrincipalRewriter(Function<Principal, Principal> principalRewriter) {
            Assert.checkNotNullParam((String)"principalRewriter", principalRewriter);
            this.assertNotBuilt();
            this.principalRewriter = principalRewriter;
            return this;
        }

        @Deprecated
        public RealmBuilder setNameRewriter(NameRewriter nameRewriter) {
            return this.setPrincipalRewriter(nameRewriter.asPrincipalRewriter());
        }

        public RoleDecoder getRoleDecoder() {
            return this.roleDecoder;
        }

        public RealmBuilder setRoleDecoder(RoleDecoder roleDecoder) {
            Assert.checkNotNullParam((String)"roleDecoder", (Object)roleDecoder);
            this.assertNotBuilt();
            this.roleDecoder = roleDecoder;
            return this;
        }

        public Builder build() {
            this.assertNotBuilt();
            return this.parent.addRealm(this);
        }

        private void assertNotBuilt() {
            this.parent.assertNotBuilt();
            if (this.built) {
                throw ElytronMessages.log.builderAlreadyBuilt();
            }
        }
    }

    public static final class Builder {
        private boolean built = false;
        private final HashMap<String, RealmBuilder> realms = new HashMap();
        private Function<Principal, Principal> preRealmRewriter = Function.identity();
        private Function<Principal, Principal> principalDecoder = Function.identity();
        private Function<Principal, Principal> postRealmRewriter = Function.identity();
        private String defaultRealmName;
        private RealmMapper realmMapper = RealmMapper.DEFAULT_REALM_MAPPER;
        private RoleMapper roleMapper = RoleMapper.IDENTITY_ROLE_MAPPER;
        private PermissionMapper permissionMapper = PermissionMapper.EMPTY_PERMISSION_MAPPER;
        private Map<String, RoleMapper> categoryRoleMappers = Collections.emptyMap();
        private UnaryOperator<SecurityIdentity> securityIdentityTransformer = UnaryOperator.identity();
        private Predicate<SecurityDomain> trustedSecurityDomain = domain -> false;

        Builder() {
        }

        public Builder setPreRealmRewriter(NameRewriter rewriter) {
            return this.setPreRealmRewriter(rewriter.asPrincipalRewriter());
        }

        public Builder setPreRealmRewriter(Function<Principal, Principal> rewriter) {
            Assert.checkNotNullParam((String)"rewriter", rewriter);
            this.assertNotBuilt();
            this.preRealmRewriter = rewriter;
            return this;
        }

        public Builder setPostRealmRewriter(NameRewriter rewriter) {
            return this.setPostRealmRewriter(rewriter.asPrincipalRewriter());
        }

        public Builder setPostRealmRewriter(Function<Principal, Principal> rewriter) {
            Assert.checkNotNullParam((String)"rewriter", rewriter);
            this.assertNotBuilt();
            this.postRealmRewriter = rewriter;
            return this;
        }

        public Builder setRealmMapper(RealmMapper realmMapper) {
            Assert.checkNotNullParam((String)"realmMapper", (Object)realmMapper);
            this.assertNotBuilt();
            this.realmMapper = realmMapper;
            return this;
        }

        public Builder setRoleMapper(RoleMapper roleMapper) {
            Assert.checkNotNullParam((String)"roleMapper", (Object)roleMapper);
            this.assertNotBuilt();
            this.roleMapper = roleMapper;
            return this;
        }

        public Builder setPermissionMapper(PermissionMapper permissionMapper) {
            Assert.checkNotNullParam((String)"permissionMapper", (Object)permissionMapper);
            this.assertNotBuilt();
            this.permissionMapper = permissionMapper;
            return this;
        }

        public Builder setPrincipalDecoder(PrincipalDecoder principalDecoder) {
            Assert.checkNotNullParam((String)"principalDecoder", (Object)principalDecoder);
            this.assertNotBuilt();
            this.principalDecoder = principalDecoder.asPrincipalRewriter();
            return this;
        }

        public RealmBuilder addRealm(String name, SecurityRealm realm) {
            Assert.checkNotNullParam((String)"name", (Object)name);
            Assert.checkNotNullParam((String)"realm", (Object)realm);
            this.assertNotBuilt();
            RealmBuilder realmBuilder = new RealmBuilder(this, name, realm);
            return realmBuilder;
        }

        Builder addRealm(RealmBuilder realmBuilder) {
            this.realms.put(realmBuilder.getName(), realmBuilder);
            return this;
        }

        public String getDefaultRealmName() {
            return this.defaultRealmName;
        }

        public Builder setDefaultRealmName(String defaultRealmName) {
            Assert.checkNotNullParam((String)"defaultRealmName", (Object)defaultRealmName);
            this.assertNotBuilt();
            this.defaultRealmName = defaultRealmName;
            return this;
        }

        public Map<String, RoleMapper> getCategoryRoleMappers() {
            return this.categoryRoleMappers;
        }

        public void setCategoryRoleMappers(Map<String, RoleMapper> categoryRoleMappers) {
            Assert.checkNotNullParam((String)"categoryRoleMappers", categoryRoleMappers);
            this.categoryRoleMappers = categoryRoleMappers;
        }

        public Builder setSecurityIdentityTransformer(UnaryOperator<SecurityIdentity> securityIdentityTransformer) {
            Assert.checkNotNullParam((String)"securityIdentityTransformer", securityIdentityTransformer);
            this.securityIdentityTransformer = securityIdentityTransformer;
            return this;
        }

        public Builder setTrustedSecurityDomainPredicate(Predicate<SecurityDomain> trustedSecurityDomain) {
            Assert.checkNotNullParam((String)"trustedSecurityDomain", trustedSecurityDomain);
            this.trustedSecurityDomain = trustedSecurityDomain;
            return this;
        }

        public SecurityDomain build() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(CREATE_SECURITY_DOMAIN);
            }
            String defaultRealmName = this.defaultRealmName;
            Assert.checkNotNullParam((String)"defaultRealmName", (Object)defaultRealmName);
            LinkedHashMap<String, RealmInfo> realmMap = new LinkedHashMap<String, RealmInfo>(this.realms.size());
            for (RealmBuilder realmBuilder : this.realms.values()) {
                realmMap.put(realmBuilder.getName(), new RealmInfo(realmBuilder));
            }
            if (!realmMap.containsKey(defaultRealmName)) {
                throw ElytronMessages.log.realmMapDoesNotContainDefault(defaultRealmName);
            }
            this.assertNotBuilt();
            this.built = true;
            if (ElytronMessages.log.isTraceEnabled()) {
                ElytronMessages.log.tracef("Building security domain with defaultRealmName %s.", defaultRealmName);
                if (realmMap.size() > 1) {
                    ElytronMessages.log.tracef("The following additional realms were added: %s.", realmMap.keySet().toString());
                }
            }
            return new SecurityDomain(this, realmMap);
        }

        void assertNotBuilt() {
            if (this.built) {
                throw ElytronMessages.log.builderAlreadyBuilt();
            }
        }
    }
}

