/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.password.impl.AbstractPasswordImpl;
import org.wildfly.security.password.interfaces.SaltedSimpleDigestPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.SaltedHashPasswordSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.util.PasswordUtil;

class SaltedSimpleDigestPasswordImpl
extends AbstractPasswordImpl
implements SaltedSimpleDigestPassword {
    private static final long serialVersionUID = -6754143875392946386L;
    private final String algorithm;
    private final byte[] digest;
    private final byte[] salt;

    SaltedSimpleDigestPasswordImpl(String algorithm, byte[] salt, byte[] digest) {
        this.algorithm = algorithm;
        this.digest = digest;
        this.salt = salt;
    }

    SaltedSimpleDigestPasswordImpl(String algorithm, SaltedHashPasswordSpec spec) {
        this(algorithm, (byte[])spec.getSalt().clone(), (byte[])spec.getHash().clone());
    }

    SaltedSimpleDigestPasswordImpl(SaltedSimpleDigestPassword password) {
        this(password.getAlgorithm(), (byte[])password.getSalt().clone(), (byte[])password.getDigest().clone());
    }

    SaltedSimpleDigestPasswordImpl(String algorithm, ClearPasswordSpec spec) throws InvalidKeySpecException {
        this.algorithm = algorithm;
        this.salt = PasswordUtil.generateRandomSalt(12);
        try {
            this.digest = SaltedSimpleDigestPasswordImpl.digestOf(algorithm, this.salt, spec.getEncodedPassword());
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.log.invalidKeySpecNoSuchMessageDigestAlgorithm(algorithm);
        }
    }

    SaltedSimpleDigestPasswordImpl(String algorithm, char[] password, SaltedPasswordAlgorithmSpec spec) throws InvalidKeySpecException {
        this(algorithm, (byte[])spec.getSalt().clone(), password);
    }

    SaltedSimpleDigestPasswordImpl(String algorithm, char[] password) throws InvalidKeySpecException {
        this(algorithm, PasswordUtil.generateRandomSalt(12), password);
    }

    private SaltedSimpleDigestPasswordImpl(String algorithm, byte[] salt, char[] password) throws InvalidKeySpecException {
        this.algorithm = algorithm;
        this.salt = salt;
        try {
            this.digest = SaltedSimpleDigestPasswordImpl.digestOf(algorithm, salt, password);
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.log.invalidKeySpecNoSuchMessageDigestAlgorithm(algorithm);
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    <S extends KeySpec> S getKeySpec(Class<S> keySpecType) throws InvalidKeySpecException {
        if (keySpecType.isAssignableFrom(SaltedHashPasswordSpec.class)) {
            return (S)((KeySpec)keySpecType.cast(new SaltedHashPasswordSpec((byte[])this.digest.clone(), (byte[])this.salt.clone())));
        }
        throw new InvalidKeySpecException();
    }

    @Override
    boolean verify(char[] guess) throws InvalidKeyException {
        try {
            return Arrays.equals(this.digest, SaltedSimpleDigestPasswordImpl.digestOf(this.algorithm, this.salt, guess));
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.log.invalidKeyNoSuchMessageDigestAlgorithm(this.algorithm);
        }
    }

    @Override
    <T extends KeySpec> boolean convertibleTo(Class<T> keySpecType) {
        return keySpecType.isAssignableFrom(SaltedHashPasswordSpec.class);
    }

    private static byte[] digestOf(String algorithm, byte[] salt, char[] password) throws NoSuchAlgorithmException {
        boolean saltFirst = SaltedSimpleDigestPasswordImpl.isSaltFirst(algorithm);
        MessageDigest md = SaltedSimpleDigestPasswordImpl.getMessageDigest(algorithm);
        byte[] passwordBytes = new String(password).getBytes(StandardCharsets.UTF_8);
        if (saltFirst) {
            md.update(salt);
            md.update(passwordBytes);
        } else {
            md.update(passwordBytes);
            md.update(salt);
        }
        return md.digest();
    }

    private static MessageDigest getMessageDigest(String algorithm) throws NoSuchAlgorithmException {
        switch (algorithm) {
            case "password-salt-digest-md5": 
            case "salt-password-digest-md5": {
                return MessageDigest.getInstance("MD5");
            }
            case "password-salt-digest-sha-1": 
            case "salt-password-digest-sha-1": {
                return MessageDigest.getInstance("SHA-1");
            }
            case "password-salt-digest-sha-256": 
            case "salt-password-digest-sha-256": {
                return MessageDigest.getInstance("SHA-256");
            }
            case "password-salt-digest-sha-384": 
            case "salt-password-digest-sha-384": {
                return MessageDigest.getInstance("SHA-384");
            }
            case "password-salt-digest-sha-512": 
            case "salt-password-digest-sha-512": {
                return MessageDigest.getInstance("SHA-512");
            }
        }
        throw ElytronMessages.log.noSuchAlgorithmInvalidAlgorithm(algorithm);
    }

    private static boolean isSaltFirst(String algorithm) throws NoSuchAlgorithmException {
        switch (algorithm) {
            case "password-salt-digest-md5": 
            case "password-salt-digest-sha-1": 
            case "password-salt-digest-sha-256": 
            case "password-salt-digest-sha-384": 
            case "password-salt-digest-sha-512": {
                return false;
            }
            case "salt-password-digest-md5": 
            case "salt-password-digest-sha-1": 
            case "salt-password-digest-sha-256": 
            case "salt-password-digest-sha-384": 
            case "salt-password-digest-sha-512": {
                return true;
            }
        }
        throw ElytronMessages.log.noSuchAlgorithmInvalidAlgorithm(algorithm);
    }

    private void readObject(ObjectInputStream ignored) throws NotSerializableException {
        throw new NotSerializableException();
    }

    Object writeReplace() {
        return SaltedSimpleDigestPassword.createRaw(this.algorithm, this.digest, this.salt);
    }

    @Override
    public SaltedSimpleDigestPasswordImpl clone() {
        return this;
    }
}

