/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.external;

import java.util.Collections;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security.sasl.WildFlySasl;
import org.wildfly.security.sasl.external.ExternalSaslClient;
import org.wildfly.security.util._private.Arrays2;

public final class ExternalSaslClientFactory
implements SaslClientFactory {
    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        for (String mechanism : mechanisms) {
            if (!"EXTERNAL".equals(mechanism)) continue;
            return new ExternalSaslClient(authorizationId);
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        if (props == null) {
            props = Collections.emptyMap();
        }
        if ("true".equals(props.get("wildfly.sasl.mechanism-query-all"))) {
            return Arrays2.of("EXTERNAL");
        }
        if ("true".equals(props.get("javax.security.sasl.policy.noactive"))) {
            return WildFlySasl.NO_NAMES;
        }
        if ("true".equals(props.get("javax.security.sasl.policy.forward"))) {
            return WildFlySasl.NO_NAMES;
        }
        if ("true".equals(props.get("javax.security.sasl.policy.noplaintext"))) {
            return WildFlySasl.NO_NAMES;
        }
        if ("true".equals(props.get("javax.security.sasl.policy.noanonymous"))) {
            return WildFlySasl.NO_NAMES;
        }
        if ("true".equals(props.get("javax.security.sasl.policy.nodictionary"))) {
            return WildFlySasl.NO_NAMES;
        }
        if ("true".equals(props.get("javax.security.sasl.policy.credentials"))) {
            return WildFlySasl.NO_NAMES;
        }
        return Arrays2.of("EXTERNAL");
    }
}

