/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security;

import java.lang.reflect.Constructor;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.credential.store.impl.MapCredentialStore;
import org.wildfly.security.credential.store.impl.VaultCredentialStore;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.impl.ServerMechanismFactoryImpl;
import org.wildfly.security.key.RSAParameterSpiImpl;
import org.wildfly.security.keystore.PasswordKeyStoreSpi;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.impl.DigestPasswordAlgorithmParametersSpiImpl;
import org.wildfly.security.password.impl.IteratedSaltedPasswordAlgorithmParametersSpiImpl;
import org.wildfly.security.password.impl.MaskedPasswordAlgorithmParametersSpiImpl;
import org.wildfly.security.password.impl.OneTimePasswordAlgorithmParametersSpiImpl;
import org.wildfly.security.password.impl.PasswordFactorySpiImpl;
import org.wildfly.security.password.impl.SaltedPasswordAlgorithmParametersSpiImpl;

public class WildFlyElytronProvider
extends Provider {
    private static final long serialVersionUID = 1267015094996624988L;
    private static final String HTTP_SERVER_FACTORY_TYPE = HttpServerAuthenticationMechanismFactory.class.getSimpleName();
    private static final String SASL_CLIENT_FACTORY_TYPE = SaslClientFactory.class.getSimpleName();
    private static final String SASL_SERVER_FACTORY_TYPE = SaslServerFactory.class.getSimpleName();
    private static final String PASSWORD_FACTORY_TYPE = PasswordFactory.class.getSimpleName();
    private static final String ALG_PARAMS_TYPE = AlgorithmParameters.class.getSimpleName();

    public WildFlyElytronProvider() {
        super("WildFlyElytron", 1.0, "WildFly Elytron Provider");
        this.putHttpAuthenticationMechanismImplementations();
        this.putKeyStoreImplementations();
        this.putPasswordImplementations();
        this.putSaslMechanismImplementations();
        this.putCredentialStoreProviderImplementations();
        this.putAlgorithmParametersImplementations();
        this.put("Alg.Alias.Data.OID.1.2.840.113549.1.7.1", "Data");
    }

    private void putAlgorithmParametersImplementations() {
        List<String> emptyList = Collections.emptyList();
        Map<String, String> emptyMap = Collections.emptyMap();
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "RSA", RSAParameterSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "crypt-md5", SaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "sun-crypt-md5", IteratedSaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "sun-crypt-md5-bare-salt", IteratedSaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "crypt-sha-256", IteratedSaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "crypt-sha-512", IteratedSaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "digest-md5", DigestPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "digest-sha", DigestPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "digest-sha-256", DigestPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "digest-sha-512", DigestPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "password-salt-digest-md5", SaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "password-salt-digest-sha-1", SaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "password-salt-digest-sha-256", SaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "password-salt-digest-sha-384", SaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "password-salt-digest-sha-512", SaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "salt-password-digest-md5", SaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "salt-password-digest-sha-1", SaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "salt-password-digest-sha-256", SaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "salt-password-digest-sha-384", SaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "salt-password-digest-sha-512", SaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "crypt-des", SaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "bsd-crypt-des", IteratedSaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "bcrypt", IteratedSaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "scram-sha-1", IteratedSaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "scram-sha-256", IteratedSaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "scram-sha-384", IteratedSaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "scram-sha-512", IteratedSaltedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "otp-md5", OneTimePasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "otp-sha1", OneTimePasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-MD5-DES", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-MD5-DES-CBC-PKCS5", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-MD5-3DES", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-MD5-3DES-CBC-PKCS5", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-SHA1-DES-EDE", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-SHA1-DES-EDE-CBC-PKCS5", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-SHA1-RC2-40", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-SHA1-RC2-40-CBC-PKCS5", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-SHA1-RC2-128", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-SHA1-RC2-128-CBC-PKCS5", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-SHA1-RC4-40", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-SHA1-RC4-40-ECB", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-SHA1-RC4-128", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-SHA1-RC4-128-ECB", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-HMAC-SHA1-AES-128", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-HMAC-SHA224-AES-128", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-HMAC-SHA384-AES-128", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-HMAC-SHA512-AES-128", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-HMAC-SHA1-AES-256", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-HMAC-SHA224-AES-256", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-HMAC-SHA384-AES-256", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-HMAC-SHA512-AES-256", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-PBKDF-HMAC-SHA1", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-PBKDF-HMAC-SHA224", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-PBKDF-HMAC-SHA256", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-PBKDF-HMAC-SHA384", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, ALG_PARAMS_TYPE, "masked-PBKDF-HMAC-SHA512", MaskedPasswordAlgorithmParametersSpiImpl.class.getName(), emptyList, emptyMap));
    }

    private void putKeyStoreImplementations() {
        List<String> emptyList = Collections.emptyList();
        Map<String, String> emptyMap = Collections.emptyMap();
        this.putService(new Provider.Service(this, "KeyStore", "PasswordFile", PasswordKeyStoreSpi.class.getName(), emptyList, emptyMap));
    }

    private void putHttpAuthenticationMechanismImplementations() {
        List<String> emptyList = Collections.emptyList();
        Map<String, String> emptyMap = Collections.emptyMap();
        ExceptionSupplier<Object, Exception> supplier = this.toSupplier(ServerMechanismFactoryImpl.class);
        this.putService(new SupplierService(this, HTTP_SERVER_FACTORY_TYPE, "BASIC", ServerMechanismFactoryImpl.class.getName(), emptyList, emptyMap, supplier));
        this.putService(new SupplierService(this, HTTP_SERVER_FACTORY_TYPE, "CLIENT-CERT", ServerMechanismFactoryImpl.class.getName(), emptyList, emptyMap, supplier));
        this.putService(new SupplierService(this, HTTP_SERVER_FACTORY_TYPE, "DIGEST", ServerMechanismFactoryImpl.class.getName(), emptyList, emptyMap, supplier));
        this.putService(new SupplierService(this, HTTP_SERVER_FACTORY_TYPE, "FORM", ServerMechanismFactoryImpl.class.getName(), emptyList, emptyMap, supplier));
        this.putService(new SupplierService(this, HTTP_SERVER_FACTORY_TYPE, "SPNEGO", ServerMechanismFactoryImpl.class.getName(), emptyList, emptyMap, supplier));
    }

    private void putPasswordImplementations() {
        List<String> emptyList = Collections.emptyList();
        Map<String, String> emptyMap = Collections.emptyMap();
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "clear", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "crypt-md5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "sun-crypt-md5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "sun-crypt-md5-bare-salt", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "crypt-sha-256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "crypt-sha-512", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "simple-digest-md2", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "simple-digest-md5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "simple-digest-sha-1", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "simple-digest-sha-256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "simple-digest-sha-384", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "simple-digest-sha-512", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "digest-md5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "digest-sha", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "digest-sha-256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "digest-sha-512", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "password-salt-digest-md5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "password-salt-digest-sha-1", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "password-salt-digest-sha-256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "password-salt-digest-sha-384", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "password-salt-digest-sha-512", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "salt-password-digest-md5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "salt-password-digest-sha-1", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "salt-password-digest-sha-256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "salt-password-digest-sha-384", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "salt-password-digest-sha-512", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "crypt-des", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "bsd-crypt-des", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "bcrypt", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "scram-sha-1", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "scram-sha-256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "scram-sha-384", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "scram-sha-512", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "otp-md5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "otp-sha1", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-MD5-DES", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-MD5-DES-CBC-PKCS5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-MD5-3DES", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-MD5-3DES-CBC-PKCS5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-SHA1-DES-EDE", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-SHA1-DES-EDE-CBC-PKCS5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-SHA1-RC2-40", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-SHA1-RC2-40-CBC-PKCS5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-SHA1-RC2-128", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-SHA1-RC2-128-CBC-PKCS5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-SHA1-RC4-40", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-SHA1-RC4-40-ECB", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-SHA1-RC4-128", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-SHA1-RC4-128-ECB", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-HMAC-SHA1-AES-128", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-HMAC-SHA224-AES-128", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-HMAC-SHA256-AES-128", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-HMAC-SHA384-AES-128", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-HMAC-SHA512-AES-128", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-HMAC-SHA1-AES-256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-HMAC-SHA224-AES-256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-HMAC-SHA256-AES-256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-HMAC-SHA384-AES-256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-HMAC-SHA512-AES-256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-PBKDF-HMAC-SHA1", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-PBKDF-HMAC-SHA224", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-PBKDF-HMAC-SHA256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-PBKDF-HMAC-SHA384", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "masked-PBKDF-HMAC-SHA512", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
    }

    private void putSaslMechanismImplementations() {
        List<String> noAliases = Collections.emptyList();
        Map<String, String> noProperties = Collections.emptyMap();
        ClassLoader myClassLoader = WildFlyElytronProvider.class.getClassLoader();
        String myClassName = WildFlyElytronProvider.class.getName();
        String myPackageWithDot = myClassName.substring(0, myClassName.lastIndexOf(46) + 1);
        ServiceLoader<SaslClientFactory> clientLoader = ServiceLoader.load(SaslClientFactory.class, myClassLoader);
        Iterator<SaslClientFactory> clientIterator = clientLoader.iterator();
        Map<String, String> props = Collections.singletonMap("wildfly.sasl.mechanism-query-all", "true");
        while (true) {
            try {
                while (clientIterator.hasNext()) {
                    String className;
                    SaslClientFactory factory = clientIterator.next();
                    if (factory.getClass().getClassLoader() != myClassLoader || !(className = factory.getClass().getName()).startsWith(myPackageWithDot)) continue;
                    String[] names = factory.getMechanismNames(props);
                    ExceptionSupplier<Object, Exception> supplier = this.toSupplier(factory.getClass());
                    for (String name : names) {
                        this.putService(new SupplierService(this, SASL_CLIENT_FACTORY_TYPE, name, className, noAliases, noProperties, supplier));
                    }
                }
            }
            catch (RuntimeException | ServiceConfigurationError factory) {
                continue;
            }
            break;
        }
        ServiceLoader<SaslServerFactory> serverLoader = ServiceLoader.load(SaslServerFactory.class, myClassLoader);
        Iterator<SaslServerFactory> serverIterator = serverLoader.iterator();
        while (true) {
            try {
                while (serverIterator.hasNext()) {
                    String className;
                    SaslServerFactory factory = serverIterator.next();
                    if (factory.getClass().getClassLoader() != myClassLoader || !(className = factory.getClass().getName()).startsWith(myPackageWithDot)) continue;
                    String[] names = factory.getMechanismNames(props);
                    ExceptionSupplier<Object, Exception> supplier = this.toSupplier(factory.getClass());
                    for (String name : names) {
                        this.putService(new SupplierService(this, SASL_SERVER_FACTORY_TYPE, name, className, noAliases, noProperties, supplier));
                    }
                }
            }
            catch (RuntimeException | ServiceConfigurationError throwable) {
                continue;
            }
            break;
        }
    }

    private ExceptionSupplier<Object, Exception> toSupplier(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        Constructor<?> found = null;
        for (Constructor<?> current : constructors) {
            Class<?>[] parameterTypes = current.getParameterTypes();
            if (parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(Provider.class)) continue;
            found = current;
            break;
        }
        if (found != null) {
            Constructor<?> constructor = found;
            return () -> constructor.newInstance(this);
        }
        return clazz::newInstance;
    }

    private void putCredentialStoreProviderImplementations() {
        List<String> emptyList = Collections.emptyList();
        Map<String, String> emptyMap = Collections.emptyMap();
        this.putService(new Provider.Service(this, "CredentialStore", KeyStoreCredentialStore.KEY_STORE_CREDENTIAL_STORE, KeyStoreCredentialStore.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, "CredentialStore", "VaultCredentialStore", VaultCredentialStore.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, "CredentialStore", "MapCredentialStore", MapCredentialStore.class.getName(), emptyList, emptyMap));
    }

    static class SupplierService
    extends Provider.Service {
        private final ExceptionSupplier<Object, Exception> supplier;

        SupplierService(Provider provider, String type, String algorithm, String className, List<String> aliases, Map<String, String> attributes, ExceptionSupplier<Object, Exception> supplier) {
            super(provider, type, algorithm, className, aliases, attributes);
            this.supplier = supplier;
        }

        @Override
        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            try {
                return this.supplier.get();
            }
            catch (Exception e) {
                throw ElytronMessages.log.noSuchAlgorithmCreateService(this.getType(), this.getAlgorithm(), e);
            }
        }
    }
}

