/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.security.Principal;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.RealmEvent;
import org.wildfly.security.cache.RealmIdentityCache;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public class CachingSecurityRealm
implements SecurityRealm {
    private final CacheableSecurityRealm realm;
    private final RealmIdentityCache cache;

    public CachingSecurityRealm(CacheableSecurityRealm realm, RealmIdentityCache cache) {
        this.realm = (CacheableSecurityRealm)Assert.checkNotNullParam((String)"realm", (Object)realm);
        this.cache = (RealmIdentityCache)Assert.checkNotNullParam((String)"cache", (Object)cache);
        if (!(realm instanceof CacheableSecurityRealm)) {
            throw ElytronMessages.log.realmCacheUnexpectedType(realm, CacheableSecurityRealm.class);
        }
        CacheableSecurityRealm cacheable = (CacheableSecurityRealm)CacheableSecurityRealm.class.cast(realm);
        cacheable.registerIdentityChangeListener(this::removeFromCache);
    }

    @Override
    public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        RealmIdentity cached = this.cache.get(principal);
        if (cached != null) {
            return cached;
        }
        RealmIdentity identity = this.getCacheableRealm().getRealmIdentity(principal);
        if (!identity.exists()) {
            return identity;
        }
        this.cache.put(principal, identity);
        return identity;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        return this.getCacheableRealm().getCredentialAcquireSupport(credentialType, algorithmName);
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return this.getCacheableRealm().getEvidenceVerifySupport(evidenceType, algorithmName);
    }

    @Override
    public void handleRealmEvent(RealmEvent event) {
        this.getCacheableRealm().handleRealmEvent(event);
    }

    public void removeFromCache(Principal principal) {
        this.cache.remove(principal);
    }

    public void removeAllFromCache() {
        this.cache.clear();
    }

    protected CacheableSecurityRealm getCacheableRealm() {
        return this.realm;
    }
}

