/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.util.Objects;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

class SetCallbackHandlerAuthenticationConfiguration
extends AuthenticationConfiguration
implements AuthenticationConfiguration.HandlesCallbacks {
    private final CallbackHandler callbackHandler;

    SetCallbackHandlerAuthenticationConfiguration(AuthenticationConfiguration parent, CallbackHandler callbackHandler) {
        super(parent.without(AuthenticationConfiguration.HandlesCallbacks.class));
        this.callbackHandler = callbackHandler;
    }

    @Override
    void handleCallbacks(AuthenticationConfiguration config, Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        this.callbackHandler.handle(callbacks);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetCallbackHandlerAuthenticationConfiguration(newParent, this.callbackHandler);
    }

    @Override
    CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    @Override
    boolean saslSupportedByConfiguration(String mechanismName) {
        return true;
    }

    @Override
    boolean halfEqual(AuthenticationConfiguration other) {
        return Objects.equals(this.callbackHandler, other.getCallbackHandler()) && this.parentHalfEqual(other);
    }

    @Override
    int calcHashCode() {
        return HashMath.multiHashUnordered((int)this.parentHashCode(), (int)1487, (int)Objects.hashCode(this.callbackHandler));
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        return this.parentAsString(sb).append("CallbackHandler,");
    }
}

