/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.security.Provider;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.ldap.EvidenceVerifier;
import org.wildfly.security.auth.realm.ldap.IdentityEvidenceVerifier;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

class DirectEvidenceVerifier
implements EvidenceVerifier {
    private final boolean allowBlankPassword;

    DirectEvidenceVerifier(boolean allowBlankPassword) {
        this.allowBlankPassword = allowBlankPassword;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return evidenceType == PasswordGuessEvidence.class ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    @Override
    public IdentityEvidenceVerifier forIdentity(final DirContext dirContext, final String distinguishedName, Attributes attributes) throws RealmUnavailableException {
        return new IdentityEvidenceVerifier(){

            @Override
            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName, Supplier<Provider[]> providers) throws RealmUnavailableException {
                return evidenceType == PasswordGuessEvidence.class && dirContext instanceof LdapContext ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean verifyEvidence(Evidence evidence, Supplier<Provider[]> providers) throws RealmUnavailableException {
                if (evidence instanceof PasswordGuessEvidence) {
                    char[] password = ((PasswordGuessEvidence)evidence).getGuess();
                    try {
                        if (!DirectEvidenceVerifier.this.allowBlankPassword && password.length == 0) {
                            ElytronMessages.log.debugf("Credential direct evidence verification does not allow blank password.", new Object[0]);
                            boolean bl = false;
                            return bl;
                        }
                        LdapContext userContext = ((LdapContext)dirContext).newInstance(null);
                        userContext.addToEnvironment("java.naming.security.principal", distinguishedName);
                        userContext.addToEnvironment("java.naming.security.credentials", password);
                        userContext.reconnect(null);
                        userContext.close();
                        boolean bl = true;
                        return bl;
                    }
                    catch (NamingException e) {
                        ElytronMessages.log.debugf("Credential direct evidence verification failed. DN: [%s]", distinguishedName, e);
                    }
                    finally {
                        ((PasswordGuessEvidence)evidence).destroy();
                    }
                }
                return false;
            }
        };
    }
}

