/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util.sso;

import java.net.URI;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.http.util.sso.SingleSignOn;
import org.wildfly.security.http.util.sso.SingleSignOnEntry;

public class DefaultSingleSignOn
implements SingleSignOn {
    private final String id;
    private final SingleSignOnEntry entry;
    private final Runnable mutator;
    private final Runnable remover;

    public DefaultSingleSignOn(String id, SingleSignOnEntry entry, Runnable mutator, Runnable remover) {
        this.id = (String)Assert.checkNotNullParam((String)"id", (Object)id);
        this.entry = (SingleSignOnEntry)Assert.checkNotNullParam((String)"entry", (Object)entry);
        this.mutator = (Runnable)Assert.checkNotNullParam((String)"mutator", (Object)mutator);
        this.remover = (Runnable)Assert.checkNotNullParam((String)"remover", (Object)remover);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getMechanism() {
        return this.entry.getCachedIdentity().getMechanismName();
    }

    @Override
    public String getName() {
        return this.entry.getCachedIdentity().getName();
    }

    @Override
    public SecurityIdentity getIdentity() {
        return this.entry.getCachedIdentity().getSecurityIdentity();
    }

    @Override
    public synchronized void setIdentity(SecurityIdentity identity) {
        CachedIdentity cached = this.entry.getCachedIdentity();
        if (cached.getSecurityIdentity() == null) {
            this.entry.setCachedIdentity(new CachedIdentity(cached.getMechanismName(), identity));
        }
    }

    @Override
    public boolean addParticipant(String applicationId, String sessionId, URI participant) {
        boolean added;
        boolean bl = added = this.entry.getParticipants().putIfAbsent(applicationId, new AbstractMap.SimpleImmutableEntry<String, URI>(sessionId, participant)) == null;
        if (added) {
            this.mutator.run();
        }
        return added;
    }

    @Override
    public Map.Entry<String, URI> removeParticipant(String applicationId) {
        Map.Entry removed = (Map.Entry)this.entry.getParticipants().remove(applicationId);
        if (removed != null) {
            this.mutator.run();
        }
        return removed;
    }

    @Override
    public Map<String, Map.Entry<String, URI>> getParticipants() {
        return Collections.unmodifiableMap(this.entry.getParticipants());
    }

    @Override
    public void invalidate() {
        this.remover.run();
    }

    @Override
    public void close() {
    }
}

