/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.util.Objects;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

class SetAuthorizationNameAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final String name;

    SetAuthorizationNameAuthenticationConfiguration(AuthenticationConfiguration parent, String name) {
        super(parent);
        this.name = name;
    }

    @Override
    String getAuthorizationName() {
        return this.name;
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetAuthorizationNameAuthenticationConfiguration(newParent, this.name);
    }

    @Override
    boolean halfEqual(AuthenticationConfiguration other) {
        return Objects.equals(this.name, other.getAuthorizationName()) && this.parentHalfEqual(other);
    }

    @Override
    int calcHashCode() {
        return HashMath.multiHashUnordered((int)this.parentHashCode(), (int)4397, (int)this.name.hashCode());
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        return this.parentAsString(sb).append("authorization-name=").append(this.name).append(',');
    }
}

