/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.EvidenceDecoder;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;
import org.wildfly.security.ssl.WrappingX509ExtendedTrustManager;

class SecurityDomainTrustManager
extends X509ExtendedTrustManager {
    private final X509ExtendedTrustManager delegate;
    private final SecurityDomain securityDomain;
    private final EvidenceDecoder evidenceDecoder;

    SecurityDomainTrustManager(X509ExtendedTrustManager delegate, SecurityDomain securityDomain, EvidenceDecoder evidenceDecoder) {
        this.delegate = delegate;
        this.securityDomain = securityDomain;
        this.evidenceDecoder = evidenceDecoder;
    }

    SecurityDomainTrustManager(X509TrustManager delegate, SecurityDomain securityDomain, EvidenceDecoder evidenceDecoder) {
        this(delegate instanceof X509ExtendedTrustManager ? (X509ExtendedTrustManager)delegate : new WrappingX509ExtendedTrustManager(delegate), securityDomain, evidenceDecoder);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, socket);
        this.doClientTrustCheck(chain, authType, ((SSLSocket)socket).getHandshakeSession());
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, sslEngine);
        this.doClientTrustCheck(chain, authType, sslEngine.getHandshakeSession());
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType);
        this.doClientTrustCheck(chain, authType, null);
    }

    private void doClientTrustCheck(X509Certificate[] chain, String authType, SSLSession handshakeSession) throws CertificateException {
        Assert.checkNotNullParam((String)"chain", (Object)chain);
        Assert.checkNotNullParam((String)"authType", (Object)authType);
        if (chain.length == 0) {
            throw ElytronMessages.log.emptyChainNotTrusted();
        }
        X509PeerCertificateChainEvidence evidence = new X509PeerCertificateChainEvidence(chain);
        Principal principal = this.evidenceDecoder.getPrincipalFromEvidence(evidence);
        ServerAuthenticationContext authenticationContext = this.securityDomain.createNewAuthenticationContext();
        boolean ok = false;
        try {
            try {
                authenticationContext.setAuthenticationPrincipal(principal);
                SupportLevel evidenceSupport = authenticationContext.getEvidenceVerifySupport(X509PeerCertificateChainEvidence.class, evidence.getAlgorithm());
                if (evidenceSupport.mayBeSupported() && authenticationContext.verifyEvidence(evidence)) {
                    authenticationContext.succeed();
                    if (handshakeSession != null) {
                        handshakeSession.putValue("org.wildfly.security.ssl.identity", authenticationContext.getAuthorizedIdentity());
                    }
                    ok = true;
                }
                throw ElytronMessages.log.notTrusted(principal);
            }
            catch (RealmUnavailableException e) {
                throw ElytronMessages.log.notTrustedRealmProblem(e, principal);
            }
        }
        catch (Throwable throwable) {
            if (!ok) {
                authenticationContext.fail();
            }
            throw throwable;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType, sslEngine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }
}

