/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.audit.AuditEndpoint;
import org.wildfly.security.audit.EventPriority;

public class FileAuditEndpoint
implements AuditEndpoint {
    private static final byte[] LINE_TERMINATOR = System.lineSeparator().getBytes(StandardCharsets.UTF_8);
    private volatile boolean accepting = true;
    private final Supplier<DateFormat> dateFormatSupplier;
    private final boolean syncOnAccept;
    private final FileDescriptor fileDescriptor;
    private final OutputStream outputStream;

    FileAuditEndpoint(Builder builder) throws IOException {
        this.dateFormatSupplier = builder.dateFormatSupplier;
        this.syncOnAccept = builder.syncOnAccept;
        FileOutputStream fos = new FileOutputStream(builder.location.toFile(), true);
        try {
            this.fileDescriptor = fos.getFD();
        }
        catch (IOException e) {
            fos.close();
            throw e;
        }
        this.outputStream = new BufferedOutputStream(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(EventPriority t, String u) throws IOException {
        if (!this.accepting) {
            return;
        }
        FileAuditEndpoint fileAuditEndpoint = this;
        synchronized (fileAuditEndpoint) {
            if (!this.accepting) {
                return;
            }
            boolean started = false;
            try {
                this.outputStream.write(this.dateFormatSupplier.get().format(new Date()).getBytes(StandardCharsets.UTF_8));
                started = true;
                this.outputStream.write(44);
                this.outputStream.write(t.toString().getBytes(StandardCharsets.UTF_8));
                this.outputStream.write(44);
                this.outputStream.write(u.getBytes(StandardCharsets.UTF_8));
                this.outputStream.write(LINE_TERMINATOR);
            }
            catch (IOException e) {
                throw started ? ElytronMessages.audit.partialSecurityEventWritten(e) : e;
            }
            if (this.syncOnAccept) {
                this.outputStream.flush();
                this.fileDescriptor.sync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.accepting = false;
        FileAuditEndpoint fileAuditEndpoint = this;
        synchronized (fileAuditEndpoint) {
            this.outputStream.flush();
            this.fileDescriptor.sync();
            this.outputStream.close();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Supplier<DateFormat> dateFormatSupplier = SimpleDateFormat::new;
        private Path location = new File("audit.log").toPath();
        private boolean syncOnAccept = true;

        Builder() {
        }

        public Builder setDateFormatSupplier(Supplier<DateFormat> dateFormatSupplier) {
            this.dateFormatSupplier = (Supplier)Assert.checkNotNullParam((String)"dateFormatSupplier", dateFormatSupplier);
            return this;
        }

        public Builder setLocation(Path location) {
            this.location = (Path)Assert.checkNotNullParam((String)"location", (Object)location);
            return this;
        }

        public Builder setSyncOnAccept(boolean syncOnAccept) {
            this.syncOnAccept = syncOnAccept;
            return this;
        }

        public AuditEndpoint build() throws IOException {
            return new FileAuditEndpoint(this);
        }
    }
}

