/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.ldap;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.provider.ldap.AttributeMapping;
import org.wildfly.security.auth.provider.ldap.CredentialLoader;
import org.wildfly.security.auth.provider.ldap.CredentialPersister;
import org.wildfly.security.auth.provider.ldap.DirContextFactory;
import org.wildfly.security.auth.provider.ldap.EvidenceVerifier;
import org.wildfly.security.auth.provider.ldap.IdentityCredentialLoader;
import org.wildfly.security.auth.provider.ldap.IdentityCredentialPersister;
import org.wildfly.security.auth.provider.ldap.IdentityEvidenceVerifier;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.AlgorithmEvidence;
import org.wildfly.security.evidence.Evidence;

class LdapSecurityRealm
implements ModifiableSecurityRealm {
    private final DirContextFactory dirContextFactory;
    private final NameRewriter nameRewriter;
    private final IdentityMapping identityMapping;
    private final List<CredentialLoader> credentialLoaders;
    private final List<CredentialPersister> credentialPersisters;
    private final List<EvidenceVerifier> evidenceVerifiers;

    LdapSecurityRealm(DirContextFactory dirContextFactory, NameRewriter nameRewriter, IdentityMapping identityMapping, List<CredentialLoader> credentialLoaders, List<CredentialPersister> credentialPersisters, List<EvidenceVerifier> evidenceVerifiers) {
        this.dirContextFactory = dirContextFactory;
        this.nameRewriter = nameRewriter;
        this.identityMapping = identityMapping;
        this.credentialLoaders = credentialLoaders;
        this.credentialPersisters = credentialPersisters;
        this.evidenceVerifiers = evidenceVerifiers;
    }

    @Override
    public RealmIdentity getRealmIdentity(String name, Principal principal, Evidence evidence) throws RealmUnavailableException {
        return this.getRealmIdentityForUpdate(name, principal, evidence);
    }

    @Override
    public ModifiableRealmIdentity getRealmIdentityForUpdate(String name, Principal principal, Evidence evidence) {
        if (name == null) {
            return ModifiableRealmIdentity.NON_EXISTENT;
        }
        if ((name = this.nameRewriter.rewriteName(name)) == null) {
            throw ElytronMessages.log.invalidName();
        }
        return new LdapRealmIdentity(name);
    }

    @Override
    public Iterator<ModifiableRealmIdentity> getRealmIdentityIterator() throws RealmUnavailableException {
        return null;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        SupportLevel response = SupportLevel.UNSUPPORTED;
        for (CredentialLoader loader : this.credentialLoaders) {
            SupportLevel support = loader.getCredentialAcquireSupport(this.dirContextFactory, credentialType, algorithmName);
            if (support.isDefinitelySupported()) {
                return support;
            }
            if (response.compareTo(support) >= 0) continue;
            response = support;
        }
        return response;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidenceType", evidenceType);
        SupportLevel response = SupportLevel.UNSUPPORTED;
        for (EvidenceVerifier verifier : this.evidenceVerifiers) {
            SupportLevel support = verifier.getEvidenceVerifySupport(this.dirContextFactory, evidenceType, algorithmName);
            if (support.isDefinitelySupported()) {
                return support;
            }
            if (response.compareTo(support) >= 0) continue;
            response = support;
        }
        return response;
    }

    static class IdentityMapping {
        private final String searchDn;
        private final boolean searchRecursive;
        private final String rdnIdentifier;
        private final List<AttributeMapping> attributes;
        public final int searchTimeLimit;
        private final LdapName newIdentityParent;
        private final javax.naming.directory.Attributes newIdentityAttributes;

        public IdentityMapping(String searchDn, boolean searchRecursive, int searchTimeLimit, String rdnIdentifier, List<AttributeMapping> attributes, LdapName newIdentityParent, javax.naming.directory.Attributes newIdentityAttributes) {
            Assert.checkNotNullParam((String)"rdnIdentifier", (Object)rdnIdentifier);
            this.searchDn = searchDn;
            this.searchRecursive = searchRecursive;
            this.searchTimeLimit = searchTimeLimit;
            this.rdnIdentifier = rdnIdentifier;
            this.attributes = attributes;
            this.newIdentityParent = newIdentityParent;
            this.newIdentityAttributes = newIdentityAttributes;
        }
    }

    private class LdapRealmIdentity
    implements ModifiableRealmIdentity {
        private final String name;
        private LdapIdentity identity;

        LdapRealmIdentity(String name) {
            this.name = name;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            if (!this.exists()) {
                return null;
            }
            if (LdapSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName) == SupportLevel.UNSUPPORTED) {
                return SupportLevel.UNSUPPORTED;
            }
            SupportLevel support = SupportLevel.UNSUPPORTED;
            for (CredentialLoader loader : LdapSecurityRealm.this.credentialLoaders) {
                if (!loader.getCredentialAcquireSupport(LdapSecurityRealm.this.dirContextFactory, credentialType, algorithmName).mayBeSupported()) continue;
                IdentityCredentialLoader icl = loader.forIdentity(LdapSecurityRealm.this.dirContextFactory, this.identity.getDistinguishedName());
                SupportLevel temp = icl.getCredentialAcquireSupport(credentialType, algorithmName);
                if (temp != null && temp.isDefinitelySupported()) {
                    return temp;
                }
                if (temp == null || support.compareTo(temp) >= 0) continue;
                support = temp;
            }
            return support;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.getCredential(credentialType, null);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            if (!this.exists()) {
                return null;
            }
            if (LdapSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName) == SupportLevel.UNSUPPORTED) {
                return null;
            }
            for (CredentialLoader loader : LdapSecurityRealm.this.credentialLoaders) {
                IdentityCredentialLoader icl;
                C credential;
                if (!loader.getCredentialAcquireSupport(LdapSecurityRealm.this.dirContextFactory, credentialType, algorithmName).mayBeSupported() || !credentialType.isInstance(credential = (icl = loader.forIdentity(LdapSecurityRealm.this.dirContextFactory, this.identity.getDistinguishedName())).getCredential(credentialType, algorithmName))) continue;
                return (C)((Credential)credentialType.cast(credential));
            }
            return null;
        }

        @Override
        public void setCredentials(Collection<? extends Credential> credentials) throws RealmUnavailableException {
            String algorithmName;
            Class<?> credentialType;
            Assert.checkNotNullParam((String)"credentials", credentials);
            if (!this.exists()) {
                throw ElytronMessages.log.ldapRealmIdentityNotExists(this.name);
            }
            for (Credential credential : credentials) {
                credentialType = credential.getClass();
                algorithmName = credential instanceof AlgorithmCredential ? ((AlgorithmCredential)credential).getAlgorithm() : null;
                boolean supported = false;
                for (CredentialPersister persister : LdapSecurityRealm.this.credentialPersisters) {
                    IdentityCredentialPersister icp = persister.forIdentity(LdapSecurityRealm.this.dirContextFactory, this.identity.getDistinguishedName());
                    if (!icp.getCredentialPersistSupport(credentialType, algorithmName)) continue;
                    supported = true;
                }
                if (supported) continue;
                throw ElytronMessages.log.ldapRealmsPersisterNotSupported();
            }
            for (CredentialPersister credentialPersister : LdapSecurityRealm.this.credentialPersisters) {
                IdentityCredentialPersister icp = credentialPersister.forIdentity(LdapSecurityRealm.this.dirContextFactory, this.identity.getDistinguishedName());
                icp.clearCredentials();
            }
            block3: for (Credential credential : credentials) {
                credentialType = credential.getClass();
                algorithmName = credential instanceof AlgorithmCredential ? ((AlgorithmCredential)credential).getAlgorithm() : null;
                for (CredentialPersister persister : LdapSecurityRealm.this.credentialPersisters) {
                    IdentityCredentialPersister icp = persister.forIdentity(LdapSecurityRealm.this.dirContextFactory, this.identity.getDistinguishedName());
                    if (!icp.getCredentialPersistSupport(credentialType, algorithmName)) continue;
                    icp.persistCredential(credential);
                    continue block3;
                }
            }
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            if (!this.exists()) {
                return AuthorizationIdentity.EMPTY;
            }
            return AuthorizationIdentity.basicIdentity(this.identity.attributes);
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidenceType", evidenceType);
            if (!this.exists()) {
                return SupportLevel.UNSUPPORTED;
            }
            SupportLevel response = SupportLevel.UNSUPPORTED;
            for (EvidenceVerifier verifier : LdapSecurityRealm.this.evidenceVerifiers) {
                if (!verifier.getEvidenceVerifySupport(LdapSecurityRealm.this.dirContextFactory, evidenceType, algorithmName).mayBeSupported()) continue;
                IdentityEvidenceVerifier iev = verifier.forIdentity(LdapSecurityRealm.this.dirContextFactory, this.identity.getDistinguishedName());
                SupportLevel support = iev.getEvidenceVerifySupport(evidenceType, algorithmName);
                if (support != null && support.isDefinitelySupported()) {
                    return support;
                }
                if (support == null || support.compareTo(support) >= 0) continue;
                response = support;
            }
            return response;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            String algorithmName;
            Assert.checkNotNullParam((String)"evidence", (Object)evidence);
            if (!this.exists()) {
                return false;
            }
            Class<?> evidenceType = evidence.getClass();
            String string = algorithmName = evidence instanceof AlgorithmEvidence ? ((AlgorithmEvidence)evidence).getAlgorithm() : null;
            if (LdapSecurityRealm.this.getEvidenceVerifySupport(evidenceType, algorithmName) == SupportLevel.UNSUPPORTED) {
                return false;
            }
            for (EvidenceVerifier verifier : LdapSecurityRealm.this.evidenceVerifiers) {
                IdentityEvidenceVerifier iev;
                if (!verifier.getEvidenceVerifySupport(LdapSecurityRealm.this.dirContextFactory, evidenceType, algorithmName).mayBeSupported() || !(iev = verifier.forIdentity(LdapSecurityRealm.this.dirContextFactory, this.identity.getDistinguishedName())).verifyEvidence(evidence)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            boolean exists;
            if (this.identity == null) {
                this.identity = this.getIdentity(this.name);
            }
            boolean bl = exists = this.identity != null;
            if (!exists) {
                ElytronMessages.log.debugf("Principal [%s] does not exists.", this.name);
            }
            return exists;
        }

        /*
         * Exception decompiling
         */
        private LdapIdentity getIdentity(String principalName) throws RealmUnavailableException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private Map<String, Collection<String>> extractFilteredAttributes(SearchResult result, DirContext context) {
            String principalDn = result.getNameInNamespace();
            return this.extractAttributes(attribute -> attribute.getFilter() != null, attribute -> {
                ArrayList values = new ArrayList();
                String searchDn = attribute.getSearchDn();
                if (searchDn == null) {
                    searchDn = LdapSecurityRealm.this.identityMapping.searchDn;
                }
                LdapSearch search = new LdapSearch(searchDn, attribute.getFilter(), principalDn);
                search.setReturningAttributes(attribute.getLdapName());
                try (Stream<SearchResult> searchResult = search.search(context);){
                    searchResult.forEach(entry -> {
                        String valueRdn = attribute.getRdn();
                        if (valueRdn != null) {
                            String entryDn = entry.getNameInNamespace();
                            try {
                                for (Rdn rdn : new LdapName(entryDn).getRdns()) {
                                    if (!rdn.getType().equalsIgnoreCase(valueRdn)) continue;
                                    values.add(rdn.getValue().toString());
                                }
                            }
                            catch (Exception cause) {
                                throw ElytronMessages.log.ldapRealmInvalidRdnForAttribute(attribute.getName(), entryDn, valueRdn);
                            }
                        } else {
                            javax.naming.directory.Attributes entryAttributes = entry.getAttributes();
                            Attribute ldapAttribute = entryAttributes.get(attribute.getLdapName());
                            NamingEnumeration<?> attributeValues = null;
                            try {
                                attributeValues = ldapAttribute.getAll();
                                while (attributeValues.hasMore()) {
                                    values.add(attributeValues.next().toString());
                                }
                            }
                            catch (Exception cause) {
                                throw ElytronMessages.log.ldapRealmFailedObtainAttributes(principalDn, cause);
                            }
                            finally {
                                if (attributeValues != null) {
                                    try {
                                        attributeValues.close();
                                    }
                                    catch (NamingException namingException) {}
                                }
                            }
                        }
                    });
                }
                catch (Exception cause) {
                    throw ElytronMessages.log.ldapRealmFailedObtainAttributes(principalDn, cause);
                }
                return values;
            });
        }

        private Map<String, Collection<String>> extractSingleAttributes(SearchResult searchResult) {
            return this.extractAttributes(attribute -> attribute.getFilter() == null, attribute -> {
                javax.naming.directory.Attributes returnedAttributes = searchResult.getAttributes();
                NamingEnumeration<? extends Attribute> attributesEnum = returnedAttributes.getAll();
                ArrayList<String> values = new ArrayList<String>();
                try {
                    NamingEnumeration<?> attributeValues;
                    while (attributesEnum.hasMore()) {
                        Attribute ldapAttribute = attributesEnum.next();
                        if (!ldapAttribute.getID().equalsIgnoreCase(attribute.getLdapName())) continue;
                        attributeValues = ldapAttribute.getAll();
                        while (attributeValues.hasMore()) {
                            String value = attributeValues.next().toString();
                            String valueRdn = attribute.getRdn();
                            if (valueRdn != null) {
                                try {
                                    for (Rdn rdn : new LdapName(value).getRdns()) {
                                        if (!rdn.getType().equalsIgnoreCase(valueRdn)) continue;
                                        value = rdn.getValue().toString();
                                        break;
                                    }
                                }
                                catch (Exception cause) {
                                    throw ElytronMessages.log.ldapRealmInvalidRdnForAttribute(attribute.getName(), value, valueRdn);
                                }
                            }
                            values.add(value);
                        }
                        if (attributeValues == null) continue;
                        try {
                            attributeValues.close();
                        }
                        catch (NamingException namingException) {
                        }
                    }
                    return values;
                    {
                        catch (Throwable throwable) {
                            if (attributeValues == null) throw throwable;
                            try {
                                attributeValues.close();
                                throw throwable;
                            }
                            catch (NamingException namingException) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
                catch (NamingException cause) {
                    throw ElytronMessages.log.ldapRealmFailedObtainAttributes(searchResult.getNameInNamespace(), cause);
                }
            });
        }

        private SearchControls createSearchControls(String ... returningAttributes) {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(LdapSecurityRealm.this.identityMapping.searchRecursive ? 2 : 1);
            searchControls.setTimeLimit(((LdapSecurityRealm)LdapSecurityRealm.this).identityMapping.searchTimeLimit);
            searchControls.setReturningAttributes(returningAttributes);
            return searchControls;
        }

        private Map<String, Collection<String>> extractAttributes(Predicate<AttributeMapping> filter, Function<AttributeMapping, Collection<String>> valueFunction) {
            return LdapSecurityRealm.this.identityMapping.attributes.stream().filter(filter).collect(Collectors.toMap(AttributeMapping::getName, valueFunction, (m1, m2) -> {
                ArrayList merged = new ArrayList(m1);
                merged.addAll(m2);
                return merged;
            }));
        }

        @Override
        public void delete() throws RealmUnavailableException {
            if (this.identity == null) {
                this.identity = this.getIdentity(this.name);
            }
            if (this.identity == null) {
                throw ElytronMessages.log.noSuchIdentity();
            }
            DirContext context = null;
            try {
                context = LdapSecurityRealm.this.dirContextFactory.obtainDirContext(null);
                ElytronMessages.log.debugf("Removing identity [%s] with DN [%s] from LDAP", this.name, this.identity.getDistinguishedName());
                context.destroySubcontext(new LdapName(this.identity.getDistinguishedName()));
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedDeleteIdentityFromServer(e);
            }
            finally {
                LdapSecurityRealm.this.dirContextFactory.returnContext(context);
            }
        }

        @Override
        public void create() throws RealmUnavailableException {
            if (LdapSecurityRealm.this.identityMapping.newIdentityParent == null || LdapSecurityRealm.this.identityMapping.newIdentityAttributes == null) {
                throw ElytronMessages.log.ldapRealmNotConfiguredToSupportCreatingIdentities();
            }
            DirContext context = null;
            try {
                context = LdapSecurityRealm.this.dirContextFactory.obtainDirContext(null);
                LdapName distinguishName = (LdapName)LdapSecurityRealm.this.identityMapping.newIdentityParent.clone();
                distinguishName.add(new Rdn(LdapSecurityRealm.this.identityMapping.rdnIdentifier, this.name));
                ElytronMessages.log.debugf("Creating identity [%s] with DN [%s] in LDAP", this.name, distinguishName.toString());
                context.createSubcontext(distinguishName, LdapSecurityRealm.this.identityMapping.newIdentityAttributes);
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedCreateIdentityOnServer(e);
            }
            finally {
                LdapSecurityRealm.this.dirContextFactory.returnContext(context);
            }
        }

        @Override
        public void setAttributes(Attributes attributes) throws RealmUnavailableException {
            ElytronMessages.log.debugf("Trying to set attributes for principal [%s].", this.name);
            if (this.identity == null) {
                this.identity = this.getIdentity(this.name);
            }
            if (this.identity == null) {
                throw ElytronMessages.log.noSuchIdentity();
            }
            DirContext context = null;
            try {
                context = LdapSecurityRealm.this.dirContextFactory.obtainDirContext(null);
                LinkedList<ModificationItem> modItems = new LinkedList<ModificationItem>();
                LdapName identityLdapName = new LdapName(this.identity.getDistinguishedName());
                String renameTo = null;
                for (AttributeMapping mapping : LdapSecurityRealm.this.identityMapping.attributes) {
                    BasicAttribute attribute;
                    if (mapping.getFilter() != null || mapping.getRdn() != null) {
                        if (attributes.size(mapping.getName()) == 0) continue;
                        ElytronMessages.log.ldapRealmDoesNotSupportSettingFilteredAttribute(mapping.getName(), this.name);
                        continue;
                    }
                    if (LdapSecurityRealm.this.identityMapping.rdnIdentifier.equalsIgnoreCase(mapping.getLdapName())) {
                        if (attributes.size(mapping.getName()) == 1) {
                            renameTo = attributes.get(mapping.getName(), 0);
                            continue;
                        }
                        throw ElytronMessages.log.ldapRealmRequireExactlyOneRdnAttribute(mapping.getName(), this.name);
                    }
                    if (attributes.size(mapping.getName()) == 0) {
                        attribute = new BasicAttribute(mapping.getLdapName());
                        modItems.add(new ModificationItem(3, attribute));
                        continue;
                    }
                    attribute = new BasicAttribute(mapping.getLdapName());
                    attributes.get(mapping.getName()).forEach(entryItem -> attribute.add(entryItem));
                    modItems.add(new ModificationItem(2, attribute));
                }
                for (Attributes.Entry entry : attributes.entries()) {
                    if (LdapSecurityRealm.this.identityMapping.attributes.stream().filter(mp -> mp.getName().equals(entry.getKey())).count() != 0L) continue;
                    throw ElytronMessages.log.ldapRealmCannotSetAttributeWithoutMapping(entry.getKey(), this.name);
                }
                ModificationItem[] modItemsArray = modItems.toArray(new ModificationItem[modItems.size()]);
                context.modifyAttributes(identityLdapName, modItemsArray);
                if (renameTo != null && !renameTo.equals((String)identityLdapName.getRdn(identityLdapName.size() - 1).getValue())) {
                    LdapName newLdapName = new LdapName(identityLdapName.getRdns().subList(0, identityLdapName.size() - 1));
                    newLdapName.add(new Rdn(LdapSecurityRealm.this.identityMapping.rdnIdentifier, renameTo));
                    context.rename(identityLdapName, newLdapName);
                }
            }
            catch (Exception e) {
                throw ElytronMessages.log.ldapRealmAttributesSettingFailed(this.name, e);
            }
            finally {
                LdapSecurityRealm.this.dirContextFactory.returnContext(context);
            }
        }

        private static /* synthetic */ void lambda$getIdentity$68(LdapIdentity identity, String key) {
            Attributes.Entry values = identity.attributes.get(key);
            values.forEach(value -> ElytronMessages.log.debugf("    Attribute [%s] value [%s].", key, value));
        }

        private /* synthetic */ LdapIdentity lambda$getIdentity$66(DirContext finalContext, SearchResult result) {
            MapAttributes identityAttributes = new MapAttributes();
            identityAttributes.addAll(this.extractSingleAttributes(result));
            identityAttributes.addAll(this.extractFilteredAttributes(result, finalContext));
            return new LdapIdentity(result.getNameInNamespace(), identityAttributes.asReadOnly());
        }

        private static /* synthetic */ String[] lambda$getIdentity$65(int x$0) {
            return new String[x$0];
        }

        private class LdapSearch {
            private final String[] filterArgs;
            private final String searchDn;
            private final String filter;
            private String[] returningAttributes;

            public LdapSearch(String searchDn, String filter, String ... filterArgs) {
                this.searchDn = searchDn;
                this.filter = filter;
                this.filterArgs = filterArgs;
            }

            public Stream<SearchResult> search(DirContext context) throws RealmUnavailableException {
                ElytronMessages.log.debugf("Executing search [%s] in context [%s] with arguments [%s]. Returning attributes are [%s]", new Object[]{this.filter, this.searchDn, this.filterArgs, this.returningAttributes});
                try {
                    final NamingEnumeration<SearchResult> result = context.search(this.searchDn, this.filter, (Object[])this.filterArgs, LdapRealmIdentity.this.createSearchControls(this.returningAttributes));
                    return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<SearchResult>(Long.MAX_VALUE, 256){

                        @Override
                        public boolean tryAdvance(Consumer<? super SearchResult> action) {
                            try {
                                if (!result.hasMore()) {
                                    return false;
                                }
                                SearchResult entry = (SearchResult)result.next();
                                ElytronMessages.log.debugf("Found entry [%s].", entry.getNameInNamespace());
                                action.accept(entry);
                                return true;
                            }
                            catch (NamingException e) {
                                throw ElytronMessages.log.ldapRealmErrorWhileConsumingResultsFromSearch(LdapSearch.this.searchDn, LdapSearch.this.filter, Arrays.toString(LdapSearch.this.filterArgs), e);
                            }
                        }
                    }, false).onClose(() -> {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (NamingException namingException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (Exception cause) {
                    throw ElytronMessages.log.ldapRealmFailedObtainIdentityFromServer(cause);
                }
            }

            public void setReturningAttributes(String ... returningAttributes) {
                this.returningAttributes = returningAttributes;
            }
        }

        private class LdapIdentity {
            private final String distinguishedName;
            private final Attributes attributes;

            LdapIdentity(String distinguishedName, Attributes attributes) {
                this.distinguishedName = distinguishedName;
                this.attributes = attributes;
            }

            String getDistinguishedName() {
                return this.distinguishedName;
            }
        }
    }
}

