/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.oauth2;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.util.ByteStringBuilder;
import org.wildfly.security.util.CodePointIterator;

class OAuth2Util {
    OAuth2Util() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static JsonObject introspectAccessToken(URL tokenIntrospectionUrl, String clientId, String clientSecret, String token, SSLContext sslContext, HostnameVerifier hostnameVerifier) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"clientId", (Object)clientId);
        Assert.checkNotNullParam((String)"clientSecret", (Object)clientSecret);
        Assert.checkNotNullParam((String)"token", (Object)token);
        HttpURLConnection connection = null;
        try {
            connection = OAuth2Util.openConnection(tokenIntrospectionUrl, sslContext, hostnameVerifier);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("token", token);
            parameters.put("token_type_hint", "access_token");
            byte[] params = OAuth2Util.buildParameters(parameters);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-Length", String.valueOf(params.length));
            connection.setRequestProperty("Authorization", "Basic " + CodePointIterator.ofString(clientId + ":" + clientSecret).asUtf8().base64Encode().drainToString());
            try (OutputStream outputStream = connection.getOutputStream();){
                outputStream.write(params);
            }
            var10_15 = null;
            try (BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());){
                JsonObject jsonObject = Json.createReader((InputStream)inputStream).readObject();
                return jsonObject;
            }
            catch (Throwable throwable7) {
                var10_15 = throwable7;
                throw throwable7;
            }
        }
        catch (IOException ioe) {
            if (connection == null) throw ElytronMessages.log.oauth2RealmTokenIntrospectionFailed(ioe);
            if (connection.getErrorStream() == null) throw ElytronMessages.log.oauth2RealmTokenIntrospectionFailed(ioe);
            InputStream errorStream = connection.getErrorStream();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream));){
                StringBuffer response = reader.lines().reduce(new StringBuffer(), StringBuffer::append, (buffer1, buffer2) -> buffer1);
                ElytronMessages.log.errorf(ioe, "Unexpected response from token introspection endpoint [%s]. Response: [%s]", tokenIntrospectionUrl, response);
                return null;
            }
            catch (IOException e) {
                throw ElytronMessages.log.oauth2RealmTokenIntrospectionFailed(ioe);
            }
        }
        catch (Exception e) {
            throw ElytronMessages.log.oauth2RealmTokenIntrospectionFailed(e);
        }
    }

    static Attributes toAttributes(JsonObject claims) {
        return claims.entrySet().stream().reduce(new MapAttributes(), (mapAttributes, entry) -> {
            String claimName = (String)entry.getKey();
            JsonValue claimValue = (JsonValue)entry.getValue();
            if (JsonValue.ValueType.ARRAY.equals((Object)claimValue.getValueType())) {
                JsonArray jsonArray = claims.getJsonArray(claimName);
                jsonArray.forEach(arrayValue -> mapAttributes.addLast(claimName, OAuth2Util.asString(arrayValue)));
            } else {
                mapAttributes.addLast(claimName, OAuth2Util.asString(claimValue));
            }
            return mapAttributes;
        }, (mapAttributes, mapAttributes2) -> mapAttributes);
    }

    private static String asString(JsonValue value) {
        if (JsonValue.ValueType.STRING.equals((Object)value.getValueType())) {
            return ((JsonString)value).getString();
        }
        return value.toString();
    }

    private static HttpURLConnection openConnection(URL url, SSLContext sslContext, HostnameVerifier hostnameVerifier) throws IOException {
        Assert.checkNotNullParam((String)"url", (Object)url);
        boolean isHttps = url.getProtocol().equalsIgnoreCase("https");
        if (isHttps) {
            if (sslContext == null) {
                throw ElytronMessages.log.oauth2RealmSSLContextNotSpecified(url);
            }
            if (hostnameVerifier == null) {
                throw ElytronMessages.log.oauth2RealmHostnameVerifierNotSpecified(url);
            }
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (isHttps) {
            HttpsURLConnection https = (HttpsURLConnection)connection;
            https.setSSLSocketFactory(sslContext.getSocketFactory());
            https.setHostnameVerifier(hostnameVerifier);
        }
        return connection;
    }

    private static byte[] buildParameters(Map<String, String> parameters) throws UnsupportedEncodingException {
        ByteStringBuilder params = new ByteStringBuilder();
        parameters.entrySet().stream().forEach(entry -> {
            if (params.length() > 0) {
                params.append('&');
            }
            params.append((String)entry.getKey()).append('=').append((String)entry.getValue());
        });
        return params.toArray();
    }
}

