/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.SetAnonymousAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCertificateCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetGSSCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetKeyManagerCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetKeyStoreCredentialAuthenticationConfiguration;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.sasl.util.SaslMechanismInformation;

class SetPasswordAuthenticationConfiguration
extends AuthenticationConfiguration {
    private static final Predicate<String> ALWAYS_MATCH_PREDICATE = prompt -> true;
    private final Password password;
    private final Predicate<String> matchPredicate;

    SetPasswordAuthenticationConfiguration(AuthenticationConfiguration parent, Password password, Predicate<String> matchPredicate) {
        super(parent.without(SetCallbackHandlerAuthenticationConfiguration.class).without(SetKeyStoreCredentialAuthenticationConfiguration.class).without(SetAnonymousAuthenticationConfiguration.class).without(SetGSSCredentialAuthenticationConfiguration.class).without(SetKeyManagerCredentialAuthenticationConfiguration.class).without(SetCertificateCredentialAuthenticationConfiguration.class), matchPredicate != null);
        this.password = password;
        this.matchPredicate = matchPredicate == null ? ALWAYS_MATCH_PREDICATE : matchPredicate;
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        PasswordCallback passwordCallback;
        Callback callback = callbacks[index];
        if (callback instanceof CredentialCallback) {
            CredentialCallback credentialCallback = (CredentialCallback)callback;
            if (credentialCallback.isCredentialTypeSupported(PasswordCredential.class, this.password.getAlgorithm())) {
                credentialCallback.setCredential(new PasswordCredential(this.password));
                return;
            }
        } else if (callback instanceof PasswordCallback && this.matchPredicate.test((passwordCallback = (PasswordCallback)callback).getPrompt()) && this.password instanceof TwoWayPassword) {
            try {
                PasswordFactory passwordFactory = PasswordFactory.getInstance(this.password.getAlgorithm());
                ClearPasswordSpec clearPasswordSpec = passwordFactory.getKeySpec(passwordFactory.translate(this.password), ClearPasswordSpec.class);
                passwordCallback.setPassword(clearPasswordSpec.getEncodedPassword());
                return;
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
        }
        super.handleCallback(callbacks, index);
    }

    @Override
    void configureSaslProperties(Map<String, Object> properties) {
        properties.put("javax.security.sasl.credentials", this.password);
        super.configureSaslProperties(properties);
    }

    @Override
    boolean filterOneSaslMechanism(String mechanismName) {
        String passwordAlgorithm = this.password.getAlgorithm();
        Set<Class<? extends Credential>> types = SaslMechanismInformation.getSupportedClientCredentialTypes(mechanismName);
        Set<String> algorithms = SaslMechanismInformation.getSupportedClientCredentialAlgorithms(mechanismName, PasswordCredential.class);
        return (types == null || types.contains(PasswordCredential.class)) && (algorithms.isEmpty() || algorithms.contains(passwordAlgorithm)) || super.filterOneSaslMechanism(mechanismName);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetPasswordAuthenticationConfiguration(newParent, this.password, this.matchPredicate);
    }
}

