/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpConstants;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerMechanismsResponder;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.http.Scope;
import org.wildfly.security.http.impl.UsernamePasswordAuthenticationMechanism;

class FormAuthenticationMechanism
extends UsernamePasswordAuthenticationMechanism {
    private static final String USERNAME = "j_username";
    private static final String PASSWORD = "j_password";
    private static final String LOCATION_KEY = FormAuthenticationMechanism.class.getName() + ".Location";
    private static final String IDENTITY_CREDENTIAL_KEY = FormAuthenticationMechanism.class.getName() + ".Identity-Credential";
    private static final String DEFAULT_POST_LOCATION = "j_security_check";
    private final String contextPath;
    private final String loginPage;
    private final String errorPage;
    private final String postLocation;

    FormAuthenticationMechanism(CallbackHandler callbackHandler, Map<String, ?> properties) {
        super((CallbackHandler)Assert.checkNotNullParam((String)"callbackHandler", (Object)callbackHandler));
        Assert.checkNotNullParam((String)"properties", properties);
        String postLocation = (String)properties.get(HttpConstants.CONFIG_POST_LOCATION);
        this.postLocation = postLocation != null ? postLocation : DEFAULT_POST_LOCATION;
        this.contextPath = properties.containsKey(HttpConstants.CONFIG_CONTEXT_PATH) ? (String)properties.get(HttpConstants.CONFIG_CONTEXT_PATH) : "";
        this.loginPage = (String)properties.get(HttpConstants.CONFIG_LOGIN_PAGE);
        this.errorPage = (String)properties.get(HttpConstants.CONFIG_ERROR_PAGE);
    }

    @Override
    public String getMechanismName() {
        return "FORM";
    }

    @Override
    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        FormIdentityCredentials identityCredentials;
        HttpScope session = request.getScope(Scope.SESSION);
        if (session != null && (identityCredentials = session.getAttachment(IDENTITY_CREDENTIAL_KEY, FormIdentityCredentials.class)) != null) {
            String username = identityCredentials.getUsername();
            char[] password = identityCredentials.getPassword();
            try {
                if (this.authenticate(null, username, password) && this.authorize(username)) {
                    this.succeed();
                    request.authenticationComplete();
                    request.resumeRequest();
                    return;
                }
                identityCredentials.dispose();
                session.setAttachment(IDENTITY_CREDENTIAL_KEY, null);
            }
            catch (IOException | UnsupportedCallbackException e) {
                throw new HttpAuthenticationException(e);
            }
            finally {
                Arrays.fill(password, '\u0000');
            }
        }
        if ("POST".equals(request.getRequestMethod()) && request.getRequestURI().getPath().endsWith(this.postLocation)) {
            this.attemptAuthentication(request);
            return;
        }
        if (this.loginPage != null) {
            request.noAuthenticationInProgress(response -> this.sendLogin(request, response));
        }
    }

    private void error(String message, HttpServerRequest request) {
        request.authenticationFailed(message, response -> this.sendPage(this.errorPage, request, response));
    }

    private void attemptAuthentication(HttpServerRequest request) throws HttpAuthenticationException {
        String username = request.getFirstParameterValue(USERNAME);
        String password = request.getFirstParameterValue(PASSWORD);
        if (username == null || password == null) {
            this.error(ElytronMessages.log.usernameOrPasswordMissing(), request);
            return;
        }
        char[] passwordChars = password.toCharArray();
        try {
            if (this.authenticate(null, username, passwordChars)) {
                if (this.authorize(username)) {
                    this.succeed();
                    HttpScope session = request.getScope(Scope.SESSION);
                    HttpServerMechanismsResponder responder = null;
                    if (session != null) {
                        session.setAttachment(IDENTITY_CREDENTIAL_KEY, new FormIdentityCredentials(username, password.toCharArray()));
                        String originalPath = session.getAttachment(LOCATION_KEY, String.class);
                        if (originalPath != null) {
                            session.setAttachment(LOCATION_KEY, null);
                            responder = response -> this.sendRedirect(response, originalPath);
                        }
                    }
                    request.authenticationComplete(responder);
                    return;
                }
                this.fail();
                this.error(ElytronMessages.log.authorizationFailed(username, "FORM"), request);
                return;
            }
            this.fail();
            this.error(ElytronMessages.log.authenticationFailed(username, "FORM"), request);
            return;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new HttpAuthenticationException(e);
        }
        finally {
            Arrays.fill(passwordChars, '\u0000');
        }
    }

    void sendLogin(HttpServerRequest request, HttpServerResponse response) throws HttpAuthenticationException {
        HttpScope session = request.getScope(Scope.SESSION);
        if (session != null && session.supportsAttachments()) {
            session.setAttachment(LOCATION_KEY, request.getRequestURI().getPath());
            request.suspendRequest();
        }
        this.sendPage(this.loginPage, request, response);
    }

    void sendPage(String page, HttpServerRequest request, HttpServerResponse response) throws HttpAuthenticationException {
        if (response.forward(page)) {
            return;
        }
        HttpScope application = request.getScope(Scope.APPLICATION);
        if (application != null && application.supportsResources()) {
            try (InputStream pageStream = application.getResource(page);){
                OutputStream responseStream;
                if (pageStream != null && (responseStream = response.getOutputStream()) != null) {
                    int length;
                    byte[] content = new byte[1024];
                    while ((length = pageStream.read(content)) > 0) {
                        responseStream.write(content, 0, length);
                    }
                    return;
                }
            }
            catch (IOException e) {
                throw new HttpAuthenticationException(e);
            }
        }
        this.sendRedirect(response, this.contextPath + page);
    }

    private void sendRedirect(HttpServerResponse response, String location) {
        response.addResponseHeader("Location", location);
        response.setStatusCode(303);
    }

    final class FormIdentityCredentials {
        private final String username;
        private final char[] password;

        FormIdentityCredentials(String username, char[] password) {
            this.username = username;
            this.password = new char[password.length];
            System.arraycopy(password, 0, this.password, 0, password.length);
        }

        String getUsername() {
            return this.username;
        }

        char[] getPassword() {
            char[] password = new char[this.password.length];
            System.arraycopy(this.password, 0, password, 0, this.password.length);
            return password;
        }

        void dispose() {
            Arrays.fill(this.password, '\u0000');
        }
    }
}

