/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.util.function.BiPredicate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

class SetChoiceAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final BiPredicate<Class<? extends ChoiceCallback>, String> matchPredicate;
    private final String choice;

    SetChoiceAuthenticationConfiguration(AuthenticationConfiguration parent, BiPredicate<Class<? extends ChoiceCallback>, String> matchPredicate, String choice) {
        super(parent, true);
        this.matchPredicate = matchPredicate;
        this.choice = choice;
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws UnsupportedCallbackException, IOException {
        ChoiceCallback choiceCallback;
        Callback callback = callbacks[index];
        if (callback instanceof ChoiceCallback && this.matchPredicate.test((choiceCallback = (ChoiceCallback)callback).getClass(), choiceCallback.getPrompt())) {
            if (this.choice == null) {
                choiceCallback.setSelectedIndex(choiceCallback.getDefaultChoice());
                return;
            }
            String[] choices = choiceCallback.getChoices();
            for (int i = 0; i < choices.length; ++i) {
                if (!this.choice.equals(choices[i])) continue;
                choiceCallback.setSelectedIndex(i);
                return;
            }
        }
        super.handleCallback(callbacks, index);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetChoiceAuthenticationConfiguration(newParent, this.matchPredicate, this.choice);
    }
}

