/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.SetAnonymousAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetPasswordCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.sasl.util.SaslMechanismInformation;

class SetCredentialsConfiguration
extends AuthenticationConfiguration {
    private static final Predicate<String> ALWAYS_MATCH_PREDICATE = prompt -> true;
    private final Supplier<IdentityCredentials> credentialsSupplier;
    private final Predicate<String> matchPredicate;

    SetCredentialsConfiguration(AuthenticationConfiguration parent, Supplier<IdentityCredentials> credentialsSupplier, Predicate<String> matchPredicate) {
        super(parent.without(SetCallbackHandlerAuthenticationConfiguration.class).without(SetAnonymousAuthenticationConfiguration.class).without(SetPasswordCallbackHandlerAuthenticationConfiguration.class), matchPredicate != null);
        this.credentialsSupplier = credentialsSupplier;
        this.matchPredicate = matchPredicate == null ? ALWAYS_MATCH_PREDICATE : matchPredicate;
    }

    SetCredentialsConfiguration(AuthenticationConfiguration parent, Supplier<IdentityCredentials> credentialsSupplier) {
        this(parent, credentialsSupplier, ALWAYS_MATCH_PREDICATE);
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws UnsupportedCallbackException, IOException {
        PasswordCallback passwordCallback;
        Callback callback = callbacks[index];
        if (callback instanceof CredentialCallback) {
            CredentialCallback credentialCallback = (CredentialCallback)callback;
            Credential credential = this.credentialsSupplier.get().getCredential(credentialCallback.getCredentialType(), credentialCallback.getAlgorithm());
            if (credential != null && credentialCallback.isCredentialSupported(credential)) {
                credentialCallback.setCredential(credential);
                return;
            }
        } else if (callback instanceof PasswordCallback && this.matchPredicate.test((passwordCallback = (PasswordCallback)callback).getPrompt())) {
            TwoWayPassword password = this.credentialsSupplier.get().applyToCredential(PasswordCredential.class, "clear", c -> c.getPassword(TwoWayPassword.class));
            if (password instanceof ClearPassword) {
                passwordCallback.setPassword(((ClearPassword)password).getPassword());
                return;
            }
            if (password != null) {
                try {
                    PasswordFactory passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
                    ClearPasswordSpec clearPasswordSpec = passwordFactory.getKeySpec(passwordFactory.translate(password), ClearPasswordSpec.class);
                    passwordCallback.setPassword(clearPasswordSpec.getEncodedPassword());
                    return;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    // empty catch block
                }
            }
        }
        super.handleCallback(callbacks, index);
    }

    @Override
    boolean filterOneSaslMechanism(String mechanismName) {
        Set<Class<? extends Credential>> types = SaslMechanismInformation.getSupportedClientCredentialTypes(mechanismName);
        IdentityCredentials credentials = this.credentialsSupplier.get();
        for (Class<? extends Credential> type : types) {
            Set<String> algorithms = SaslMechanismInformation.getSupportedClientCredentialAlgorithms(mechanismName, type);
            if (algorithms.contains("*")) {
                if (!credentials.getCredentialAcquireSupport(type, null).mayBeSupported()) continue;
                return true;
            }
            for (String algorithm : algorithms) {
                if (!credentials.getCredentialAcquireSupport(type, algorithm).mayBeSupported()) continue;
                return true;
            }
        }
        return super.filterOneSaslMechanism(mechanismName);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetCredentialsConfiguration(newParent, this.credentialsSupplier, this.matchPredicate);
    }
}

