/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store.impl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.credential.store.impl.CommandCredentialStore;

public class ExecPasswordStore
extends CommandCredentialStore {
    public static final String EXEC_PASSWORD_STORE = "ExecPasswordStore";
    public static final String SUPPORTED_CMD_TYPE = "EXT";

    public ExecPasswordStore() {
        this.storeName = "exec";
    }

    @Override
    char[] executePasswordCommand(String passwordCommand) throws Throwable {
        String passwordCmdLine;
        String passwordCmdType;
        if (passwordCommand.trim().startsWith("{EXT")) {
            StringTokenizer tokenizer = new StringTokenizer(passwordCommand, "{}");
            passwordCmdType = tokenizer.nextToken();
            passwordCmdLine = tokenizer.nextToken();
        } else {
            passwordCmdType = SUPPORTED_CMD_TYPE;
            passwordCmdLine = passwordCommand;
        }
        if (!passwordCmdType.equals(SUPPORTED_CMD_TYPE)) {
            throw ElytronMessages.log.cacheForExternalCommandsNotSupported();
        }
        try {
            return this.execCmd(passwordCmdLine);
        }
        catch (Exception e) {
            throw ElytronMessages.log.passwordCommandExecutionProblem(this.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] execCmd(String cmd) throws Exception {
        String line;
        Runtime rt = Runtime.getRuntime();
        Process p = rt.exec(cmd);
        InputStream stdin = null;
        BufferedReader reader = null;
        try {
            stdin = p.getInputStream();
            reader = new BufferedReader(new InputStreamReader(stdin));
            line = reader.readLine();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (stdin != null) {
                stdin.close();
            }
        }
        int exitCode = p.waitFor();
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("Exit code from password command = %d", exitCode);
        }
        return line != null ? line.toCharArray() : null;
    }
}

