/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.util;

import java.security.Principal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.util.ElytronMessages;
import org.wildfly.security.evidence.Evidence;

public class SimpleRegexRealmMapper
implements RealmMapper {
    private final Pattern realmNamePattern;
    private final RealmMapper delegate;

    public SimpleRegexRealmMapper(Pattern realmNamePattern) {
        this(realmNamePattern, DEFAULT_REALM_MAPPER);
    }

    public SimpleRegexRealmMapper(Pattern realmNamePattern, RealmMapper delegate) {
        Assert.checkNotNullParam((String)"realmNamePattern", (Object)realmNamePattern);
        Assert.checkNotNullParam((String)"delegate", (Object)delegate);
        int groupCount = realmNamePattern.matcher("").groupCount();
        if (groupCount < 1) {
            throw ElytronMessages.log.patternRequiresCaptureGroup();
        }
        this.realmNamePattern = realmNamePattern;
        this.delegate = delegate;
    }

    @Override
    public String getRealmMapping(Principal principal, Evidence evidence) {
        if (principal instanceof NamePrincipal) {
            String name = principal.getName();
            Matcher matcher = this.realmNamePattern.matcher(name);
            assert (matcher.groupCount() >= 1);
            return matcher.matches() ? matcher.group(1) : this.delegate.getRealmMapping(principal, evidence);
        }
        return null;
    }
}

