/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util.sso;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.util.sso.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String warnHttpMechSsoFailedLogoutParticipant = "ELY06008: Failed to logout participant [%s]. Participant will be removed from list of participants but its local session may still be active.";
    private static final String httpMechSsoInvalidLogoutMessage = "ELY06012: Invalid logout message received for local session [%s]";
    private static final String errorHttpMechSsoFailedInvalidateLocalSession = "ELY06013: Failed to invalidate local session";
    private static final String httpServerAuthenticationMechanismNotFound = "ELY06014: Authentication mechanism '%s' cannot be found";

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void warnHttpMechSsoFailedLogoutParticipant(String url, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.warnHttpMechSsoFailedLogoutParticipant$str(), (Object)url);
    }

    protected String warnHttpMechSsoFailedLogoutParticipant$str() {
        return warnHttpMechSsoFailedLogoutParticipant;
    }

    protected String httpMechSsoInvalidLogoutMessage$str() {
        return httpMechSsoInvalidLogoutMessage;
    }

    @Override
    public final IllegalStateException httpMechSsoInvalidLogoutMessage(String localSessionId) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.httpMechSsoInvalidLogoutMessage$str(), localSessionId));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void errorHttpMechSsoFailedInvalidateLocalSession(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorHttpMechSsoFailedInvalidateLocalSession$str(), new Object[0]);
    }

    protected String errorHttpMechSsoFailedInvalidateLocalSession$str() {
        return errorHttpMechSsoFailedInvalidateLocalSession;
    }

    protected String httpServerAuthenticationMechanismNotFound$str() {
        return httpServerAuthenticationMechanismNotFound;
    }

    @Override
    public final HttpAuthenticationException httpServerAuthenticationMechanismNotFound(String mechanismName) {
        HttpAuthenticationException result = new HttpAuthenticationException(String.format(this.getLoggingLocale(), this.httpServerAuthenticationMechanismNotFound$str(), mechanismName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

