/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.security.KeyPair;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.sshd.client.config.keys.ClientIdentityProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;

public class LazyClientIdentityIterator
implements Iterator<KeyPair> {
    protected boolean finished;
    protected Iterator<? extends KeyPair> currentIdentities;
    protected KeyPair currentPair;
    private final Iterator<? extends ClientIdentityProvider> providers;
    private final Function<? super ClientIdentityProvider, ? extends Iterable<? extends KeyPair>> kpExtractor;
    private final Predicate<? super KeyPair> filter;

    public LazyClientIdentityIterator(Iterator<? extends ClientIdentityProvider> providers, Function<? super ClientIdentityProvider, ? extends Iterable<? extends KeyPair>> kpExtractor, Predicate<? super KeyPair> filter) {
        this.providers = providers;
        this.kpExtractor = Objects.requireNonNull(kpExtractor, "No key pair extractor provided");
        this.filter = filter;
    }

    public Iterator<? extends ClientIdentityProvider> getProviders() {
        return this.providers;
    }

    public Function<? super ClientIdentityProvider, ? extends Iterable<? extends KeyPair>> getIdentitiesExtractor() {
        return this.kpExtractor;
    }

    public Predicate<? super KeyPair> getFilter() {
        return this.filter;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        Iterator<? extends ClientIdentityProvider> provs = this.getProviders();
        if (provs == null) {
            this.finished = true;
            return false;
        }
        this.currentPair = KeyIdentityProvider.exhaustCurrentIdentities(this.currentIdentities);
        if (this.currentPair != null) {
            return true;
        }
        Function<? super ClientIdentityProvider, ? extends Iterable<? extends KeyPair>> x = this.getIdentitiesExtractor();
        Predicate<? super KeyPair> f = this.getFilter();
        while (provs.hasNext()) {
            ClientIdentityProvider p = provs.next();
            if (p == null) continue;
            Iterable<? extends KeyPair> ids = x.apply(p);
            this.currentIdentities = ids == null ? null : ids.iterator();
            this.currentPair = KeyIdentityProvider.exhaustCurrentIdentities(this.currentIdentities);
            if (this.currentPair == null || f != null && !f.test(this.currentPair)) continue;
            return true;
        }
        this.finished = true;
        return false;
    }

    @Override
    public KeyPair next() {
        if (this.finished) {
            throw new NoSuchElementException("All identities have been exhausted");
        }
        if (this.currentPair == null) {
            throw new IllegalStateException("'next()' called without asking 'hasNext()'");
        }
        KeyPair kp = this.currentPair;
        this.currentPair = null;
        return kp;
    }

    public String toString() {
        return ClientIdentityProvider.class.getSimpleName() + "[lazy-iterator]";
    }
}

