/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.util.EnumSet;
import java.util.Iterator;
import org.wildfly.security.ssl.CipherSuitePredicate;
import org.wildfly.security.ssl.MechanismDatabase;
import org.wildfly.security.ssl.Protocol;

final class ProtocolCipherSuitePredicate
extends CipherSuitePredicate {
    private final EnumSet<Protocol> set;

    ProtocolCipherSuitePredicate(EnumSet<Protocol> set) {
        this.set = set;
    }

    @Override
    void toString(StringBuilder b) {
        b.append("protocol is one of (");
        Iterator iterator = this.set.iterator();
        if (iterator.hasNext()) {
            Protocol protocol = (Protocol)((Object)iterator.next());
            b.append((Object)protocol);
            while (iterator.hasNext()) {
                protocol = (Protocol)((Object)iterator.next());
                b.append(", ");
                b.append((Object)protocol);
            }
        }
        b.append(')');
    }

    @Override
    public boolean test(MechanismDatabase.Entry entry) {
        return this.set.contains((Object)entry.getProtocol());
    }

    @Override
    boolean isAlwaysTrue() {
        return this.set.size() == Protocol.fullSize;
    }

    @Override
    boolean isAlwaysFalse() {
        return this.set.isEmpty();
    }
}

